/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.expression;

import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.expression.UnaryExpression;
import com.shapesecurity.shift.ast.operators.PostfixOperator;
import com.shapesecurity.shift.ast.operators.Precedence;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class PostfixExpression
extends UnaryExpression {
    @NotNull
    public final PostfixOperator operator;

    public PostfixExpression(@NotNull PostfixOperator operator, @NotNull Expression operand) {
        super(operand);
        this.operator = operator;
    }

    @Override
    public Precedence getPrecedence() {
        return Precedence.POSTFIX;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.PostfixExpression;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PostfixExpression && this.operand.equals(((PostfixExpression)object).operand) && this.operator.equals(((PostfixExpression)object).operator);
    }

    @NotNull
    public PostfixOperator getOperator() {
        return this.operator;
    }

    @NotNull
    public PostfixExpression setOperator(@NotNull PostfixOperator operator) {
        return new PostfixExpression(operator, this.operand);
    }

    @NotNull
    public PostfixExpression setOperand(@NotNull Expression operand) {
        return new PostfixExpression(this.operator, operand);
    }
}

