/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.expression;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.expression.LeftHandSideExpression;
import com.shapesecurity.shift.ast.operators.Precedence;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class NewExpression
extends LeftHandSideExpression {
    @NotNull
    public final Expression callee;
    @NotNull
    public final ImmutableList<Expression> arguments;

    public NewExpression(@NotNull Expression callee, @NotNull ImmutableList<Expression> arguments) {
        this.callee = callee;
        this.arguments = arguments;
    }

    @Override
    public Precedence getPrecedence() {
        return this.arguments.isEmpty() ? Precedence.NEW : Precedence.MEMBER;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.NewExpression;
    }

    public boolean equals(Object object) {
        return object instanceof NewExpression && this.callee.equals(((NewExpression)object).callee) && this.arguments.equals(((NewExpression)object).arguments);
    }

    @NotNull
    public Expression getCallee() {
        return this.callee;
    }

    @NotNull
    public ImmutableList<Expression> getArguments() {
        return this.arguments;
    }

    @NotNull
    public NewExpression setCallee(@NotNull Expression callee) {
        return new NewExpression(callee, this.arguments);
    }

    @NotNull
    public NewExpression setArguments(@NotNull ImmutableList<Expression> arguments) {
        return new NewExpression(this.callee, arguments);
    }
}

