/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.expression;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.shift.ast.Function;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.expression.PrimaryExpression;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class FunctionExpression
extends PrimaryExpression
implements Function {
    @NotNull
    public final Maybe<Identifier> name;
    @NotNull
    public final ImmutableList<Identifier> parameters;
    @NotNull
    public final FunctionBody body;

    public FunctionExpression(@NotNull Maybe<Identifier> name, @NotNull ImmutableList<Identifier> parameters, @NotNull FunctionBody body) {
        this.name = name;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.FunctionExpression;
    }

    public boolean equals(Object object) {
        return object instanceof FunctionExpression && this.name.equals(((FunctionExpression)object).name) && this.parameters.equals(((FunctionExpression)object).parameters) && this.body.equals(((FunctionExpression)object).body);
    }

    @Override
    @NotNull
    public ImmutableList<Identifier> parameters() {
        return this.parameters;
    }

    @NotNull
    public Maybe<Identifier> getName() {
        return this.name;
    }

    @NotNull
    public ImmutableList<Identifier> getParameters() {
        return this.parameters;
    }

    @NotNull
    public FunctionBody getBody() {
        return this.body;
    }

    @NotNull
    public FunctionExpression setName(@NotNull Maybe<Identifier> name) {
        return new FunctionExpression(name, this.parameters, this.body);
    }

    @NotNull
    public FunctionExpression setParameters(@NotNull ImmutableList<Identifier> parameters) {
        return new FunctionExpression(this.name, parameters, this.body);
    }

    @NotNull
    public FunctionExpression setBody(@NotNull FunctionBody body) {
        return new FunctionExpression(this.name, this.parameters, body);
    }
}

