/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.expression;

import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.operators.Precedence;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class ConditionalExpression
extends Expression {
    @NotNull
    public final Expression test;
    @NotNull
    public final Expression consequent;
    @NotNull
    public final Expression alternate;

    public ConditionalExpression(@NotNull Expression test, @NotNull Expression consequent, @NotNull Expression alternate) {
        this.test = test;
        this.consequent = consequent;
        this.alternate = alternate;
    }

    @Override
    public Precedence getPrecedence() {
        return Precedence.CONDITIONAL;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.ConditionalExpression;
    }

    public boolean equals(Object object) {
        return object instanceof ConditionalExpression && this.test.equals(((ConditionalExpression)object).test) && this.consequent.equals(((ConditionalExpression)object).consequent) && this.alternate.equals(((ConditionalExpression)object).alternate);
    }

    @NotNull
    public Expression getTest() {
        return this.test;
    }

    @NotNull
    public Expression getConsequent() {
        return this.consequent;
    }

    @NotNull
    public Expression getAlternate() {
        return this.alternate;
    }

    @NotNull
    public ConditionalExpression setTest(@NotNull Expression test) {
        return new ConditionalExpression(test, this.consequent, this.alternate);
    }

    @NotNull
    public ConditionalExpression setConsequent(@NotNull Expression consequent) {
        return new ConditionalExpression(this.test, consequent, this.alternate);
    }

    @NotNull
    public ConditionalExpression setAlternate(@NotNull Expression alternate) {
        return new ConditionalExpression(this.test, this.consequent, alternate);
    }
}

