/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.expression;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.expression.LeftHandSideExpression;
import com.shapesecurity.shift.ast.operators.Precedence;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class CallExpression
extends LeftHandSideExpression {
    @NotNull
    public final Expression callee;
    @NotNull
    public final ImmutableList<Expression> arguments;

    public CallExpression(@NotNull Expression callee, @NotNull ImmutableList<Expression> arguments) {
        this.callee = callee;
        this.arguments = arguments;
    }

    @Override
    public Precedence getPrecedence() {
        return Precedence.CALL;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.CallExpression;
    }

    public boolean equals(Object object) {
        return object instanceof CallExpression && this.callee.equals(((CallExpression)object).callee) && this.arguments.equals(((CallExpression)object).arguments);
    }

    @NotNull
    public Expression getCallee() {
        return this.callee;
    }

    @NotNull
    public ImmutableList<Expression> getArguments() {
        return this.arguments;
    }

    @NotNull
    public CallExpression setCallee(@NotNull Expression callee) {
        return new CallExpression(callee, this.arguments);
    }

    @NotNull
    public CallExpression setArguments(@NotNull ImmutableList<Expression> arguments) {
        return new CallExpression(this.callee, arguments);
    }
}

