/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast;

import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class VariableDeclaration
extends Node {
    @NotNull
    public final VariableDeclarationKind kind;
    @NotNull
    public final NonEmptyImmutableList<VariableDeclarator> declarators;

    public VariableDeclaration(@NotNull VariableDeclarationKind kind, @NotNull NonEmptyImmutableList<VariableDeclarator> declarators) {
        this.kind = kind;
        this.declarators = declarators;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.VariableDeclaration;
    }

    public boolean equals(Object obj) {
        return obj instanceof VariableDeclaration && ((VariableDeclaration)obj).declarators.equals(this.declarators) && ((VariableDeclaration)obj).kind.equals((Object)this.kind);
    }

    @NotNull
    public VariableDeclarationKind getKind() {
        return this.kind;
    }

    @NotNull
    public NonEmptyImmutableList<VariableDeclarator> getDeclarators() {
        return this.declarators;
    }

    @NotNull
    public VariableDeclaration setKind(@NotNull VariableDeclarationKind kind) {
        return new VariableDeclaration(kind, this.declarators);
    }

    @NotNull
    public VariableDeclaration setDeclarators(@NotNull NonEmptyImmutableList<VariableDeclarator> declarators) {
        return new VariableDeclaration(this.kind, declarators);
    }

    public static enum VariableDeclarationKind {
        Var("var"),
        Const("const"),
        Let("let");

        public final String name;

        private VariableDeclarationKind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

