/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class SwitchCase
extends Node {
    @NotNull
    public final Expression test;
    @NotNull
    public final ImmutableList<Statement> consequent;

    public SwitchCase(@NotNull Expression test, @NotNull ImmutableList<Statement> consequent) {
        this.test = test;
        this.consequent = consequent;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.SwitchCase;
    }

    public boolean equals(Object object) {
        return object instanceof SwitchCase && this.test.equals(((SwitchCase)object).test) && this.consequent.equals(((SwitchCase)object).consequent);
    }

    @NotNull
    public Expression getTest() {
        return this.test;
    }

    @NotNull
    public ImmutableList<Statement> getConsequent() {
        return this.consequent;
    }

    @NotNull
    public SwitchCase setTest(@NotNull Expression test) {
        return new SwitchCase(test, this.consequent);
    }

    @NotNull
    public SwitchCase setConsequent(@NotNull ImmutableList<Statement> consequent) {
        return new SwitchCase(this.test, consequent);
    }
}

