/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast;

import com.shapesecurity.functional.Thunk;
import com.shapesecurity.functional.data.HashCodeBuilder;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.shift.ast.ReplacementChild;
import com.shapesecurity.shift.ast.types.GenType;
import com.shapesecurity.shift.ast.types.Type;
import com.shapesecurity.shift.parser.Located;
import com.shapesecurity.shift.path.Branch;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public abstract class Node
extends Located {
    private final Thunk<Integer> hashCodeThunk = Thunk.from(this::calcHashCode);

    private int calcHashCode() {
        Field[] fields;
        int start = 0;
        start = HashCodeBuilder.put(start, this.getClass().getName());
        for (Field field : fields = this.getClass().getFields()) {
            if (field.getModifiers() != 17) continue;
            try {
                start = HashCodeBuilder.put(start, field.get(this));
            }
            catch (IllegalAccessException ignored) {
                start = HashCodeBuilder.put(start, -1);
            }
        }
        return start;
    }

    public final int hashCode() {
        return this.hashCodeThunk.get();
    }

    @NotNull
    public abstract Type type();

    @NotNull
    public GenType genType() {
        return this.type();
    }

    @NotNull
    public Maybe<Node> get(@NotNull Branch branch) {
        return Maybe.fromNullable(branch.view(this));
    }

    @NotNull
    public Node set(@NotNull ImmutableList<ReplacementChild> list) {
        return list.foldLeft((me, rep) -> rep.branch.set((Node)me, rep.child), this);
    }
}

