/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Directive;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class FunctionBody
extends Node {
    @NotNull
    public final ImmutableList<Directive> directives;
    @NotNull
    public final ImmutableList<Statement> statements;
    private final boolean isStrict;

    public FunctionBody(@NotNull ImmutableList<Directive> directives, @NotNull ImmutableList<Statement> statements) {
        this.directives = directives;
        this.statements = statements;
        this.isStrict = directives.exists(directive -> directive instanceof UseStrictDirective);
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.FunctionBody;
    }

    public boolean equals(Object object) {
        return object instanceof FunctionBody && this.directives.equals(((FunctionBody)object).directives) && this.statements.equals(((FunctionBody)object).statements) && this.isStrict == ((FunctionBody)object).isStrict;
    }

    @NotNull
    public ImmutableList<Directive> getDirectives() {
        return this.directives;
    }

    @NotNull
    public ImmutableList<Statement> getStatements() {
        return this.statements;
    }

    @NotNull
    public FunctionBody setDirectives(@NotNull ImmutableList<Directive> directives) {
        return new FunctionBody(directives, this.statements);
    }

    @NotNull
    public FunctionBody setStatements(@NotNull ImmutableList<Statement> statements) {
        return new FunctionBody(this.directives, statements);
    }
}

