/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.HashCodeBuilder;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import org.jetbrains.annotations.NotNull;

public final class NonEmptyImmutableList<T>
extends ImmutableList<T> {
    @NotNull
    public final T head;
    @NotNull
    public final ImmutableList<T> tail;

    protected NonEmptyImmutableList(@NotNull T head, @NotNull ImmutableList<T> tail) {
        super(tail.length + 1);
        this.head = head;
        this.tail = tail;
    }

    @NotNull
    public ImmutableList<T> tail() {
        return this.tail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonEmptyImmutableList)) {
            return false;
        }
        NonEmptyImmutableList list = (NonEmptyImmutableList)o;
        return this.head.equals(list.head) && this.tail().equals(list.tail());
    }

    @Override
    @NotNull
    public <A> A foldLeft(@NotNull F2<A, ? super T, A> f, @NotNull A init) {
        ImmutableList list = this;
        while (list instanceof NonEmptyImmutableList) {
            init = f.apply(init, list.head);
            list = list.tail();
        }
        return init;
    }

    @Override
    @NotNull
    public <A> A foldRight(@NotNull F2<? super T, A, A> f, @NotNull A init) {
        return f.apply(this.head, this.tail().foldRight(f, init));
    }

    @Override
    @NotNull
    public Maybe<T> maybeHead() {
        return Maybe.just(this.head);
    }

    @Override
    @NotNull
    public Maybe<T> maybeLast() {
        if (this.tail().isEmpty()) {
            return Maybe.just(this.head);
        }
        return this.tail().maybeLast();
    }

    @Override
    @NotNull
    public Maybe<ImmutableList<T>> maybeTail() {
        return Maybe.just(this.tail());
    }

    @Override
    @NotNull
    public Maybe<ImmutableList<T>> maybeInit() {
        if (this.tail().isEmpty()) {
            return Maybe.just(NonEmptyImmutableList.nil());
        }
        return this.tail().maybeInit().map((A t) -> t.cons(this.head));
    }

    @NotNull
    public final T last() {
        NonEmptyImmutableList nel = this;
        while (!nel.tail().isEmpty()) {
            nel = (NonEmptyImmutableList)nel.tail();
        }
        return nel.head;
    }

    @NotNull
    public final ImmutableList<T> init() {
        if (this.tail().isEmpty()) {
            return NonEmptyImmutableList.nil();
        }
        return NonEmptyImmutableList.cons(this.head, ((NonEmptyImmutableList)this.tail()).init());
    }

    @Override
    @NotNull
    public ImmutableList<T> filter(@NotNull F<T, Boolean> f) {
        return f.apply(this.head) != false ? NonEmptyImmutableList.cons(this.head, this.tail().filter(f)) : this.tail().filter(f);
    }

    @Override
    @NotNull
    public <B> NonEmptyImmutableList<B> map(@NotNull F<T, B> f) {
        return ImmutableList.cons(f.apply(this.head), this.tail().map(f));
    }

    @Override
    @NotNull
    public final <B> NonEmptyImmutableList<B> mapWithIndex(@NotNull F2<Integer, T, B> f) {
        int length = this.length;
        Object[] result = new Object[length];
        ImmutableList list = this;
        for (int i = 0; i < length; ++i) {
            result[i] = f.apply(i, list.head);
            list = list.tail();
        }
        ImmutableList nList = NonEmptyImmutableList.nil();
        for (int i = length - 1; i >= 0; --i) {
            nList = nList.cons(result[i]);
        }
        return (NonEmptyImmutableList)nList;
    }

    @Override
    @NotNull
    public ImmutableList<T> take(int n) {
        if (n <= 0) {
            return NonEmptyImmutableList.nil();
        }
        return NonEmptyImmutableList.cons(this.head, this.tail().take(n - 1));
    }

    @Override
    @NotNull
    public ImmutableList<T> drop(int n) {
        if (n <= 0) {
            return this;
        }
        return this.tail().drop(n - 1);
    }

    @Override
    @NotNull
    public Maybe<NonEmptyImmutableList<T>> toNonEmptyList() {
        return Maybe.just(this);
    }

    @Override
    @NotNull
    public <B> Maybe<B> decons(@NotNull F2<T, ImmutableList<T>, B> f) {
        return Maybe.just(f.apply(this.head, this.tail()));
    }

    @Override
    @NotNull
    public <B, C> ImmutableList<C> zipWith(@NotNull F2<T, B, C> f, @NotNull ImmutableList<B> list) {
        if (list instanceof NonEmptyImmutableList) {
            NonEmptyImmutableList nonEmptyList = (NonEmptyImmutableList)list;
            return ImmutableList.cons(f.apply(this.head, nonEmptyList.head), this.tail().zipWith(f, nonEmptyList.tail()));
        }
        return NonEmptyImmutableList.nil();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public <B extends T> ImmutableList<T> append(@NotNull ImmutableList<B> defaultClause) {
        return NonEmptyImmutableList.cons(this.head, this.tail().append(defaultClause));
    }

    @Override
    public boolean exists(@NotNull F<T, Boolean> f) {
        return f.apply(this.head) != false || this.tail().exists(f);
    }

    @Override
    @NotNull
    public Pair<ImmutableList<T>, ImmutableList<T>> span(@NotNull F<T, Boolean> f) {
        if (!f.apply(this.head).booleanValue()) {
            return new Pair<ImmutableList<T>, ImmutableList<T>>(NonEmptyImmutableList.nil(), this);
        }
        Pair<ImmutableList<T>, ImmutableList<T>> s = this.tail().span(f);
        return new Pair<ImmutableList<T>, ImmutableList<T>>(((ImmutableList)s.a).cons(this.head), s.b);
    }

    @Override
    @NotNull
    public <B> ImmutableList<B> flatMap(@NotNull F<T, ImmutableList<B>> f) {
        return f.apply(this.head).append(this.tail().flatMap(f));
    }

    @Override
    @NotNull
    public ImmutableList<T> removeAll(@NotNull F<T, Boolean> f) {
        if (f.apply(this.head).booleanValue()) {
            return this.tail().removeAll(f);
        }
        return NonEmptyImmutableList.cons(this.head, this.tail().removeAll(f));
    }

    @Override
    @NotNull
    public NonEmptyImmutableList<T> reverse() {
        return this.reverse(NonEmptyImmutableList.nil());
    }

    @Override
    @NotNull
    public <B, C> Pair<B, ImmutableList<C>> mapAccumL(@NotNull F2<B, T, Pair<B, C>> f, @NotNull B acc) {
        Pair<B, C> pair = f.apply(acc, this.head);
        Pair<B, ImmutableList<C>> bListPair = this.tail().mapAccumL(f, pair.a);
        return new Pair(bListPair.a, ImmutableList.cons(pair.b, (ImmutableList)bListPair.b));
    }

    @NotNull
    private NonEmptyImmutableList<T> reverse(@NotNull ImmutableList<T> acc) {
        if (this.tail().isEmpty()) {
            return acc.cons(this.head);
        }
        return ((NonEmptyImmutableList)this.tail()).reverse(NonEmptyImmutableList.cons(this.head, acc));
    }

    @Override
    protected int calcHashCode() {
        int start = HashCodeBuilder.init();
        start = HashCodeBuilder.put(start, "List");
        start = HashCodeBuilder.put(start, this.head);
        return HashCodeBuilder.put(start, this.tail);
    }
}

