/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.Hasher;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import org.jetbrains.annotations.NotNull;

public abstract class HashTable<K, V> {
    private static final Hasher<Object> DEFAULT_HASHER = new Hasher<Object>(){

        @Override
        public int hash(@NotNull Object data) {
            return data.hashCode();
        }

        @Override
        public boolean eq(@NotNull Object o, @NotNull Object b) {
            return o.equals(b);
        }
    };
    @NotNull
    public final Hasher<K> hasher;
    public final int length;

    protected HashTable(@NotNull Hasher<K> hasher, int length) {
        this.hasher = hasher;
        this.length = length;
    }

    @NotNull
    public static <K> Hasher<K> defaultHasher() {
        return DEFAULT_HASHER;
    }

    @NotNull
    public static <K, V> HashTable<K, V> empty(@NotNull Hasher<K> hasher) {
        return new Empty(hasher);
    }

    @NotNull
    public static <K, V> HashTable<K, V> empty() {
        return HashTable.empty(HashTable.defaultHasher());
    }

    @NotNull
    public final HashTable<K, V> put(@NotNull K key, @NotNull V value) {
        return this.put(key, value, this.hasher.hash(key));
    }

    @NotNull
    public final HashTable<K, V> remove(@NotNull K key) {
        return this.remove(key, this.hasher.hash(key)).orJust(this);
    }

    @NotNull
    protected abstract HashTable<K, V> put(@NotNull K var1, @NotNull V var2, int var3);

    @NotNull
    protected abstract Maybe<HashTable<K, V>> remove(@NotNull K var1, int var2);

    @NotNull
    public final Maybe<V> get(@NotNull K key) {
        return this.get(key, this.hasher.hash(key));
    }

    @NotNull
    protected abstract Maybe<V> get(@NotNull K var1, int var2);

    @NotNull
    public final HashTable<K, V> merge(@NotNull HashTable<K, V> tree) {
        return this.merge(tree, (a, b) -> b);
    }

    @NotNull
    public abstract HashTable<K, V> merge(@NotNull HashTable<K, V> var1, @NotNull F2<V, V, V> var2);

    @NotNull
    public abstract <A> A foldLeft(@NotNull F2<A, Pair<K, V>, A> var1, @NotNull A var2);

    @NotNull
    public abstract <A> A foldRight(@NotNull F2<Pair<K, V>, A, A> var1, @NotNull A var2);

    @NotNull
    public ImmutableList<Pair<K, V>> entries() {
        return this.foldRight((kvPair, pairs) -> pairs.cons(kvPair), ImmutableList.nil());
    }

    public abstract void foreach(@NotNull Effect<Pair<K, V>> var1);

    @NotNull
    public abstract Maybe<Pair<K, V>> find(@NotNull F<Pair<K, V>, Boolean> var1);

    @NotNull
    public abstract <R> Maybe<R> findMap(@NotNull F<Pair<K, V>, Maybe<R>> var1);

    public abstract <B> HashTable<K, B> map(@NotNull F<V, B> var1);

    private static final class Fork<K, V>
    extends HashTable<K, V> {
        @NotNull
        private final HashTable<K, V>[] children;

        private Fork(@NotNull Hasher<K> hasher, @NotNull HashTable<K, V>[] children, int length) {
            super(hasher, length);
            this.children = children;
        }

        @Override
        @NotNull
        protected HashTable<K, V> put(@NotNull K key, @NotNull V value, int hash) {
            int subHash = hash & 0x1F;
            HashTable[] cloned = (HashTable[])this.children.clone();
            if (cloned[subHash] == null) {
                cloned[subHash] = new Leaf(this.hasher, ImmutableList.nil(), hash >>> 5, 0);
            }
            int length1 = cloned[subHash].length;
            cloned[subHash] = cloned[subHash].put(key, value, hash >>> 5);
            return new Fork<K, V>(this.hasher, cloned, this.length - length1 + cloned[subHash].length);
        }

        @Override
        @NotNull
        protected Maybe<HashTable<K, V>> remove(@NotNull K key, int hash) {
            int subHash = hash & 0x1F;
            if (this.children[subHash] == null) {
                return Maybe.nothing();
            }
            Maybe<HashTable<K, V>> removed = this.children[subHash].remove(key, hash >>> 5);
            return removed.map((A newChild) -> {
                HashTable[] cloned = (HashTable[])this.children.clone();
                cloned[n] = newChild;
                return new Fork<K, V>(this.hasher, cloned, this.length - 1);
            });
        }

        @Override
        @NotNull
        protected Maybe<V> get(@NotNull K key, int hash) {
            int subHash = hash & 0x1F;
            if (this.children[subHash] == null) {
                return Maybe.nothing();
            }
            return this.children[subHash].get(key, hash >>> 5);
        }

        @Override
        @NotNull
        public Fork<K, V> merge(@NotNull HashTable<K, V> tree, @NotNull F2<V, V, V> merger) {
            if (tree instanceof Empty) {
                return this;
            }
            if (tree instanceof Leaf) {
                Leaf leaf = (Leaf)tree;
                return this.mergeFork(leaf.toFork(), merger);
            }
            return this.mergeFork((Fork)tree, merger);
        }

        @NotNull
        private Fork<K, V> mergeFork(@NotNull Fork<K, V> tree, @NotNull F2<V, V, V> merger) {
            HashTable[] cloned = (HashTable[])this.children.clone();
            int count = 0;
            for (int i = 0; i < cloned.length; ++i) {
                if (cloned[i] == null) {
                    cloned[i] = tree.children[i];
                } else if (tree.children[i] != null) {
                    cloned[i] = cloned[i].merge(tree.children[i], merger);
                }
                if (cloned[i] == null) continue;
                count += cloned[i].length;
            }
            return new Fork<K, V>(this.hasher, cloned, count);
        }

        @Override
        @NotNull
        public <A> A foldLeft(@NotNull F2<A, Pair<K, V>, A> f, @NotNull A init) {
            for (HashTable<K, V> child : this.children) {
                if (child == null) continue;
                init = child.foldLeft(f, init);
            }
            return init;
        }

        @Override
        @NotNull
        public <A> A foldRight(@NotNull F2<Pair<K, V>, A, A> f, @NotNull A init) {
            for (int i = this.children.length - 1; i >= 0; --i) {
                if (this.children[i] == null) continue;
                init = this.children[i].foldRight(f, init);
            }
            return init;
        }

        @Override
        public void foreach(@NotNull Effect<Pair<K, V>> e) {
            for (HashTable<K, V> child : this.children) {
                if (child == null) continue;
                child.foreach(e);
            }
        }

        @Override
        @NotNull
        public Maybe<Pair<K, V>> find(@NotNull F<Pair<K, V>, Boolean> f) {
            for (HashTable<K, V> child : this.children) {
                Maybe<Pair<K, V>> p;
                if (child == null || !(p = child.find(f)).isJust()) continue;
                return p;
            }
            return Maybe.nothing();
        }

        @Override
        @NotNull
        public <R> Maybe<R> findMap(@NotNull F<Pair<K, V>, Maybe<R>> f) {
            for (HashTable<K, V> child : this.children) {
                Maybe<R> p;
                if (child == null || !(p = child.findMap(f)).isJust()) continue;
                return p;
            }
            return Maybe.nothing();
        }

        @Override
        public <B> Fork<K, B> map(@NotNull F<V, B> f) {
            HashTable[] clone = new HashTable[this.children.length];
            for (int i = 0; i < clone.length; ++i) {
                if (this.children[i] == null) continue;
                clone[i] = this.children[i].map(f);
            }
            return new Fork<K, V>(this.hasher, clone, this.length);
        }
    }

    private static final class Leaf<K, V>
    extends HashTable<K, V> {
        @NotNull
        private final ImmutableList<Pair<K, V>> dataList;
        public int baseHash;

        protected Leaf(@NotNull Hasher<K> hasher, @NotNull ImmutableList<Pair<K, V>> dataList, int baseHash, int length) {
            super(hasher, length);
            this.dataList = dataList;
            this.baseHash = baseHash;
        }

        @Override
        @NotNull
        protected HashTable<K, V> put(@NotNull K key, @NotNull V value, int hash) {
            if (hash == this.baseHash) {
                Pair result = this.dataList.mapAccumL((found, kvPair) -> {
                    if (found.booleanValue()) {
                        return new Pair<Boolean, Pair>(true, (Pair)kvPair);
                    }
                    if (this.hasher.eq(kvPair.a, key)) {
                        return new Pair<Boolean, Pair<Object, Object>>(true, new Pair<Object, Object>(key, value));
                    }
                    return new Pair<Boolean, Pair>(false, (Pair)kvPair);
                }, false);
                if (((Boolean)result.a).booleanValue()) {
                    return new Leaf<K, V>(this.hasher, (ImmutableList)result.b, hash, this.length);
                }
                return new Leaf<K, V>(this.hasher, this.dataList.cons(new Pair<K, V>(key, value)), hash, this.length + 1);
            }
            return this.toFork().put(key, value, hash);
        }

        @Override
        @NotNull
        protected Maybe<HashTable<K, V>> remove(@NotNull K key, int hash) {
            if (this.baseHash != hash) {
                return Maybe.nothing();
            }
            Pair result = this.dataList.foldRight((? super A i, B p) -> {
                if (((Boolean)p.a).booleanValue()) {
                    return new Pair<Boolean, NonEmptyImmutableList<Pair>>(true, ((ImmutableList)p.b).cons(i));
                }
                if (this.hasher.eq(i.a, key)) {
                    return new Pair(true, p.b);
                }
                return new Pair<Boolean, NonEmptyImmutableList<Pair>>(false, ((ImmutableList)p.b).cons(i));
            }, new Pair(false, ImmutableList.nil()));
            if (((Boolean)result.a).booleanValue()) {
                if (this.length == 1) {
                    return Maybe.just(HashTable.empty());
                }
                return Maybe.just(new Leaf<K, V>(this.hasher, (ImmutableList)result.b, this.baseHash, this.length - 1));
            }
            return Maybe.nothing();
        }

        private Fork<K, V> toFork() {
            int subHash = this.baseHash & 0x1F;
            HashTable[] children = new HashTable[32];
            children[subHash] = new Leaf<K, V>(this.hasher, this.dataList, this.baseHash >>> 5, this.length);
            return new Fork(this.hasher, children, this.length);
        }

        @Override
        @NotNull
        protected Maybe<V> get(@NotNull K key, int hash) {
            if (this.baseHash != hash) {
                return Maybe.nothing();
            }
            Maybe<Pair> pairMaybe = this.dataList.find((A kvPair) -> this.hasher.eq(kvPair.a, key));
            return pairMaybe.map((A p) -> p.b);
        }

        @Override
        @NotNull
        public HashTable<K, V> merge(@NotNull HashTable<K, V> tree, @NotNull F2<V, V, V> merger) {
            if (tree instanceof Empty) {
                return this;
            }
            if (tree instanceof Leaf) {
                Leaf leaf = (Leaf)tree;
                if (leaf.baseHash == this.baseHash) {
                    Pair[] pairs = this.dataList.toArray(new Pair[this.dataList.length]);
                    ImmutableList right = leaf.dataList.foldLeft((B result, ? super A kvPair) -> {
                        for (int i = 0; i < pairs.length; ++i) {
                            if (!this.hasher.eq(pairArray[i].a, kvPair.a)) continue;
                            pairArray[i] = new Pair(pairArray[i].a, merger.apply(pairArray[i].b, kvPair.b));
                            return result;
                        }
                        return result.cons(kvPair);
                    }, ImmutableList.nil());
                    ImmutableList<Pair<K, V>> newList = ImmutableList.from(pairs).append(right);
                    return new Leaf<K, V>(this.hasher, newList, this.baseHash, newList.length);
                }
            }
            return this.toFork().merge((HashTable)tree, (F2)merger);
        }

        @Override
        @NotNull
        public <A> A foldLeft(@NotNull F2<A, Pair<K, V>, A> f, @NotNull A init) {
            return this.dataList.foldLeft(f, init);
        }

        @Override
        @NotNull
        public <A> A foldRight(@NotNull F2<Pair<K, V>, A, A> f, @NotNull A init) {
            return this.dataList.foldRight(f, init);
        }

        @Override
        public void foreach(@NotNull Effect<Pair<K, V>> e) {
            this.dataList.foreach(e);
        }

        @Override
        @NotNull
        public Maybe<Pair<K, V>> find(@NotNull F<Pair<K, V>, Boolean> f) {
            return this.dataList.find(f);
        }

        @Override
        @NotNull
        public <R> Maybe<R> findMap(@NotNull F<Pair<K, V>, Maybe<R>> f) {
            return this.dataList.findMap(f);
        }

        @Override
        public <B> Leaf<K, B> map(@NotNull F<V, B> f) {
            return new Leaf<K, V>(this.hasher, this.dataList.map((A pair) -> pair.mapB(f)), this.baseHash, this.length);
        }
    }

    private static final class Empty<K, V>
    extends HashTable<K, V> {
        protected Empty(@NotNull Hasher<K> hasher) {
            super(hasher, 0);
        }

        @Override
        @NotNull
        protected HashTable<K, V> put(@NotNull K key, @NotNull V value, int hash) {
            return new Leaf(this.hasher, ImmutableList.list(new Pair<K, V>(key, value), new Pair[0]), hash, 1);
        }

        @Override
        @NotNull
        protected Maybe<HashTable<K, V>> remove(@NotNull K key, int hash) {
            return Maybe.nothing();
        }

        @Override
        @NotNull
        protected Maybe<V> get(@NotNull K key, int hash) {
            return Maybe.nothing();
        }

        @Override
        @NotNull
        public HashTable<K, V> merge(@NotNull HashTable<K, V> tree, @NotNull F2<V, V, V> merger) {
            return tree;
        }

        @Override
        @NotNull
        public <A> A foldLeft(@NotNull F2<A, Pair<K, V>, A> f, @NotNull A init) {
            return init;
        }

        @Override
        @NotNull
        public <A> A foldRight(@NotNull F2<Pair<K, V>, A, A> f, @NotNull A init) {
            return init;
        }

        @Override
        public void foreach(@NotNull Effect<Pair<K, V>> e) {
        }

        @Override
        @NotNull
        public Maybe<Pair<K, V>> find(@NotNull F<Pair<K, V>, Boolean> f) {
            return Maybe.nothing();
        }

        @Override
        @NotNull
        public <R> Maybe<R> findMap(@NotNull F<Pair<K, V>, Maybe<R>> f) {
            return Maybe.nothing();
        }

        @Override
        public <B> HashTable<K, B> map(@NotNull F<V, B> f) {
            return Empty.empty();
        }
    }
}

