/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.data.Maybe;
import org.jetbrains.annotations.NotNull;

public abstract class Either<A, B> {
    private Either() {
    }

    @NotNull
    public static <A, B> Left<A, B> left(@NotNull A a) {
        return new Left(a);
    }

    @NotNull
    public static <A, B> Right<A, B> right(@NotNull B b) {
        return new Right(b);
    }

    @NotNull
    public static <A, B extends A, C extends A> A extract(Either<B, C> e) {
        return (A)e.either(x -> x, x -> x);
    }

    public abstract boolean isLeft();

    public final boolean isRight() {
        return !this.isLeft();
    }

    public abstract <X> X either(F<A, X> var1, F<B, X> var2);

    @NotNull
    public abstract <X, Y> Either<X, Y> map(F<A, X> var1, F<B, Y> var2);

    @NotNull
    public abstract <X> Either<X, B> mapLeft(@NotNull F<A, X> var1);

    @NotNull
    public abstract <Y> Either<A, Y> mapRight(@NotNull F<B, Y> var1);

    @NotNull
    public abstract Maybe<A> left();

    @NotNull
    public abstract Maybe<B> right();

    public abstract boolean eq(Either<A, B> var1);

    public abstract int hashCode();

    public final boolean equals(Object object) {
        return this == object || object instanceof Either && this.eq((Either)object);
    }

    public static final class Right<A, B>
    extends Either<A, B> {
        @NotNull
        public final B b;

        private Right(@NotNull B b) {
            this.b = b;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public int hashCode() {
            return this.b.hashCode();
        }

        @Override
        public <X> X either(F<A, X> f1, F<B, X> f2) {
            return f2.apply(this.b);
        }

        @Override
        @NotNull
        public <X, Y> Either<X, Y> map(F<A, X> f1, F<B, Y> f2) {
            return Either.right(f2.apply(this.b));
        }

        @Override
        @NotNull
        public <X> Right<X, B> mapLeft(@NotNull F<A, X> f) {
            return this;
        }

        @Override
        @NotNull
        public <C> Right<A, C> mapRight(@NotNull F<B, C> f) {
            return Either.right(f.apply(this.b));
        }

        @Override
        @NotNull
        public Maybe<A> left() {
            return Maybe.nothing();
        }

        @Override
        @NotNull
        public Maybe<B> right() {
            return Maybe.just(this.b);
        }

        @Override
        public boolean eq(Either<A, B> either) {
            return either instanceof Right && this.b.equals(((Right)either).b);
        }
    }

    public static final class Left<A, B>
    extends Either<A, B> {
        @NotNull
        public final A a;

        private Left(@NotNull A a) {
            this.a = a;
        }

        @Override
        public int hashCode() {
            return this.a.hashCode();
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public <X> X either(F<A, X> f1, F<B, X> f2) {
            return f1.apply(this.a);
        }

        @Override
        @NotNull
        public <X, Y> Left<X, Y> map(F<A, X> f1, F<B, Y> f2) {
            return Either.left(f1.apply(this.a));
        }

        @Override
        @NotNull
        public <X> Left<X, B> mapLeft(@NotNull F<A, X> f) {
            return Either.left(f.apply(this.a));
        }

        @Override
        @NotNull
        public Maybe<A> left() {
            return Maybe.just(this.a);
        }

        @Override
        @NotNull
        public Maybe<B> right() {
            return Maybe.nothing();
        }

        @Override
        public boolean eq(Either<A, B> either) {
            return either instanceof Left && this.a.equals(((Left)either).a);
        }

        @Override
        @NotNull
        public <C> Left<A, C> mapRight(@NotNull F<B, C> f) {
            return this;
        }
    }
}

