/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Monoid;
import org.jetbrains.annotations.NotNull;

public abstract class ConcatList<T> {
    private static final Empty<Object> EMPTY = new Empty();
    private static BinaryTreeMonoid<Object> MONOID = new BinaryTreeMonoid();
    public final int length;

    protected ConcatList(int length) {
        this.length = length;
    }

    @NotNull
    public static <T> ConcatList<T> empty() {
        return EMPTY;
    }

    @NotNull
    public static <T> ConcatList<T> single(@NotNull T scope) {
        return new Leaf(scope);
    }

    public static <T> Monoid<ConcatList<T>> monoid() {
        return MONOID;
    }

    @NotNull
    public final ImmutableList<T> toList() {
        return this.toList(ImmutableList.nil());
    }

    protected abstract ImmutableList<T> toList(@NotNull ImmutableList<T> var1);

    @NotNull
    public abstract <B> B foldLeft(@NotNull F2<B, ? super T, B> var1, @NotNull B var2);

    @NotNull
    public abstract <B> B foldRight(@NotNull F2<? super T, B, B> var1, @NotNull B var2);

    public abstract boolean isEmpty();

    @NotNull
    public abstract ConcatList<T> append(@NotNull ConcatList<? extends T> var1);

    @NotNull
    public final ConcatList<T> append1(@NotNull T element) {
        return this.append(ConcatList.single(element));
    }

    public abstract boolean exists(@NotNull F<T, Boolean> var1);

    @NotNull
    public abstract Maybe<T> find(@NotNull F<T, Boolean> var1);

    @NotNull
    public abstract ConcatList<T> reverse();

    @NotNull
    public abstract Maybe<T> index(int var1);

    @NotNull
    public abstract Maybe<ConcatList<T>> update(int var1, @NotNull T var2);

    private static class BinaryTreeMonoid<T>
    implements Monoid<ConcatList<T>> {
        private BinaryTreeMonoid() {
        }

        @Override
        @NotNull
        public ConcatList<T> identity() {
            return new Empty();
        }

        @Override
        @NotNull
        public ConcatList<T> append(ConcatList<T> a, ConcatList<T> b) {
            return a.append(b);
        }
    }

    public static final class Fork<T>
    extends ConcatList<T> {
        @NotNull
        public final ConcatList<T> left;
        @NotNull
        public final ConcatList<T> right;

        private Fork(@NotNull ConcatList<T> left, @NotNull ConcatList<T> right) {
            super(left.length + right.length);
            this.left = left;
            this.right = right;
        }

        @Override
        @NotNull
        protected ImmutableList<T> toList(@NotNull ImmutableList<T> acc) {
            return this.left.toList(this.right.toList(acc));
        }

        @Override
        @NotNull
        public <B> B foldLeft(@NotNull F2<B, ? super T, B> f, @NotNull B init) {
            return this.right.foldLeft(f, this.left.foldLeft(f, init));
        }

        @Override
        @NotNull
        public <B> B foldRight(@NotNull F2<? super T, B, B> f, @NotNull B init) {
            return this.left.foldRight(f, this.right.foldRight(f, init));
        }

        @Override
        public boolean isEmpty() {
            return this.left.isEmpty() || this.right.isEmpty();
        }

        @Override
        @NotNull
        public ConcatList<T> append(@NotNull ConcatList<? extends T> rhs) {
            return new Fork<T>(this, rhs);
        }

        @Override
        public boolean exists(@NotNull F<T, Boolean> f) {
            return this.left.exists(f) || this.right.exists(f);
        }

        @Override
        @NotNull
        public Maybe<T> find(@NotNull F<T, Boolean> f) {
            Maybe<T> foundLeft = this.left.find(f);
            if (foundLeft.isNothing()) {
                return this.right.find(f);
            }
            return foundLeft;
        }

        @Override
        @NotNull
        public Fork<T> reverse() {
            return new Fork<T>(this.right.reverse(), this.left.reverse());
        }

        @Override
        @NotNull
        public Maybe<T> index(int index) {
            if (index >= this.length) {
                return Maybe.nothing();
            }
            return index < this.left.length ? this.left.index(index) : this.right.index(index - this.left.length);
        }

        @Override
        @NotNull
        public Maybe<ConcatList<T>> update(int index, @NotNull T element) {
            if (index >= this.length) {
                return Maybe.nothing();
            }
            ConcatList<T> left = this.left;
            ConcatList<T> right = this.right;
            if (index < this.left.length) {
                left = left.update(index, element).just();
            } else {
                right = right.update(index - this.left.length, element).just();
            }
            return Maybe.just(left.append(right));
        }
    }

    public static final class Leaf<T>
    extends ConcatList<T> {
        @NotNull
        public final T data;

        private Leaf(@NotNull T data) {
            super(1);
            this.data = data;
        }

        @Override
        @NotNull
        protected ImmutableList<T> toList(@NotNull ImmutableList<T> acc) {
            return acc.cons(this.data);
        }

        @Override
        @NotNull
        public <B> B foldLeft(@NotNull F2<B, ? super T, B> f, @NotNull B init) {
            return f.apply(init, this.data);
        }

        @Override
        @NotNull
        public <B> B foldRight(@NotNull F2<? super T, B, B> f, @NotNull B init) {
            return f.apply(this.data, init);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public ConcatList<T> append(@NotNull ConcatList<? extends T> rhs) {
            return new Fork(this, rhs);
        }

        @Override
        public boolean exists(@NotNull F<T, Boolean> f) {
            return f.apply(this.data);
        }

        @Override
        @NotNull
        public Maybe<T> find(@NotNull F<T, Boolean> f) {
            if (f.apply(this.data).booleanValue()) {
                return Maybe.just(this.data);
            }
            return Maybe.nothing();
        }

        @Override
        @NotNull
        public ConcatList<T> reverse() {
            return this;
        }

        @Override
        @NotNull
        public Maybe<T> index(int index) {
            return Maybe.iff(index == 0, this.data);
        }

        @Override
        @NotNull
        public Maybe<ConcatList<T>> update(int index, @NotNull T element) {
            return index == 0 ? Maybe.just(Leaf.single(element)) : Maybe.nothing();
        }
    }

    public static final class Empty<T>
    extends ConcatList<T> {
        private Empty() {
            super(0);
        }

        @Override
        @NotNull
        protected ImmutableList<T> toList(@NotNull ImmutableList<T> acc) {
            return acc;
        }

        @Override
        @NotNull
        public <B> B foldLeft(@NotNull F2<B, ? super T, B> f, @NotNull B init) {
            return init;
        }

        @Override
        @NotNull
        public <B> B foldRight(@NotNull F2<? super T, B, B> f, @NotNull B init) {
            return init;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public ConcatList<T> append(@NotNull ConcatList<? extends T> rhs) {
            return rhs;
        }

        @Override
        public boolean exists(@NotNull F<T, Boolean> f) {
            return false;
        }

        @Override
        @NotNull
        public Maybe<T> find(@NotNull F<T, Boolean> f) {
            return Maybe.nothing();
        }

        @Override
        @NotNull
        public ConcatList<T> reverse() {
            return this;
        }

        @Override
        @NotNull
        public Maybe<T> index(int index) {
            return Maybe.nothing();
        }

        @Override
        @NotNull
        public Maybe<ConcatList<T>> update(int index, @NotNull T element) {
            return Maybe.nothing();
        }
    }
}

