/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.data.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

public final class Pair<A, B> {
    @NotNull
    public final A a;
    @NotNull
    public final B b;

    public Pair(@NotNull A a, @NotNull B b) {
        this.a = a;
        this.b = b;
    }

    @NotNull
    public Pair<B, A> swap() {
        return new Pair<B, A>(this.b, this.a);
    }

    @NotNull
    public <A1> Pair<A1, B> mapA(@NotNull F<A, A1> f) {
        return new Pair<A1, B>(f.apply(this.a), this.b);
    }

    @NotNull
    public <B1> Pair<A, B1> mapB(@NotNull F<B, B1> f) {
        return new Pair<A, B1>(this.a, f.apply(this.b));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Pair && ((Pair)obj).a.equals(this.a) && ((Pair)obj).b.equals(this.b);
    }

    public int hashCode() {
        int hash = HashCodeBuilder.put(HashCodeBuilder.init(), "Tuple2");
        hash = HashCodeBuilder.put(hash, this.a);
        return HashCodeBuilder.put(hash, this.b);
    }
}

