/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FailDotExpression;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.Arrays;
import java.util.List;

public class ArrayExpression
extends AbstractNode {
    private ExpressionNode[] children;

    public ArrayExpression(ExpressionNode[] children, Location location) {
        super(location);
        this.children = children;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        ArrayNode array = NodeUtils.mapper.createArrayNode();
        for (int ix = 0; ix < this.children.length; ++ix) {
            array.add(this.children[ix].apply(scope, input));
        }
        return array;
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        FailDotExpression fail = new FailDotExpression(this.location, "array");
        for (int ix = 0; ix < this.children.length; ++ix) {
            this.children[ix].computeMatchContexts(fail);
        }
    }

    @Override
    public List<ExpressionNode> getChildren() {
        return Arrays.asList(this.children);
    }

    @Override
    public ExpressionNode optimize() {
        boolean allLiterals = true;
        for (int ix = 0; ix < this.children.length; ++ix) {
            this.children[ix] = this.children[ix].optimize();
            allLiterals = allLiterals && this.children[ix] instanceof LiteralExpression;
        }
        if (!allLiterals) {
            return this;
        }
        JsonNode array = this.apply(null, null);
        return new LiteralExpression(array, this.location);
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + '[');
        for (int ix = 0; ix < this.children.length; ++ix) {
            this.children[ix].dump(level + 1);
        }
        System.out.println(NodeUtils.indent(level) + ']');
    }
}

