/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOperator
extends AbstractNode {
    protected ExpressionNode left;
    protected ExpressionNode right;
    private String operator;

    public AbstractOperator(ExpressionNode left, ExpressionNode right, String operator, Location location) {
        super(location);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode v1 = this.left.apply(scope, input);
        JsonNode v2 = this.right.apply(scope, input);
        return this.perform(v1, v2);
    }

    @Override
    public void dump(int level) {
        this.left.dump(level + 1);
        System.out.println(NodeUtils.indent(level) + this.operator);
        this.right.dump(level + 1);
    }

    @Override
    public ExpressionNode optimize() {
        this.left = this.left.optimize();
        this.right = this.right.optimize();
        if (this.left instanceof LiteralExpression && this.right instanceof LiteralExpression) {
            return new LiteralExpression(this.apply(null, null), this.location);
        }
        return this;
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        this.left.computeMatchContexts(parent);
        this.right.computeMatchContexts(parent);
    }

    @Override
    public List<ExpressionNode> getChildren() {
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>(2);
        children.add(this.left);
        children.add(this.right);
        return children;
    }

    public abstract JsonNode perform(JsonNode var1, JsonNode var2);

    public String toString() {
        String first = this.left instanceof AbstractOperator ? "(" + this.left + ")" : this.left.toString();
        String second = this.right instanceof AbstractOperator ? "(" + this.right + ")" : this.right.toString();
        return first + " " + this.operator + " " + second;
    }

    public ExpressionNode getLeft() {
        return this.left;
    }

    public ExpressionNode getRight() {
        return this.right;
    }

    public String getOperator() {
        return this.operator;
    }
}

