/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.Immutable;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

@Immutable
public enum AuthenticationMethodType {
    PASSWORD,
    PBKDF2,
    LDAP,
    SAML,
    SAPLOGON,
    JWT,
    KERBEROS,
    SESSIONCOOKIE;

    public static final String DEFAULT_METHOD_NAMES;

    public static Set<AuthenticationMethodType> decode(String value) {
        String[] authMethodNames = value.toUpperCase(Locale.ENGLISH).split(",");
        EnumSet<AuthenticationMethodType> authMethodTypes = EnumSet.noneOf(AuthenticationMethodType.class);
        for (String authMethodName : authMethodNames) {
            try {
                AuthenticationMethodType authMethodType = AuthenticationMethodType.valueOf(authMethodName.trim());
                authMethodTypes.add(authMethodType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return authMethodTypes;
    }

    static {
        StringBuilder builder = new StringBuilder(64);
        for (AuthenticationMethodType authMethodType : AuthenticationMethodType.values()) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(authMethodType.name());
        }
        DEFAULT_METHOD_NAMES = builder.toString();
    }
}

