/*
 * Decompiled with CFR 0.152.
 */
package com.rudderstack.sdk.java.messages;

import com.google.auto.value.AutoValue;
import com.rudderstack.sdk.java.gson.AutoGson;
import com.rudderstack.sdk.java.messages.AutoValue_TrackMessage;
import com.rudderstack.sdk.java.messages.ImmutableMap;
import com.rudderstack.sdk.java.messages.Message;
import com.rudderstack.sdk.java.messages.MessageBuilder;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

@AutoGson
@AutoValue
public abstract class TrackMessage
implements Message {
    public static Builder builder(String event) {
        return new Builder(event);
    }

    public abstract String event();

    @Nullable
    public abstract Map<String, ?> properties();

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends MessageBuilder<TrackMessage, Builder> {
        private String event;
        private Map<String, ?> properties;

        private Builder(TrackMessage track) {
            super(track);
            this.event = track.event();
            this.properties = track.properties();
        }

        private Builder(String event) {
            super(Message.Type.track);
            if (Builder.isNullOrEmpty(event)) {
                throw new IllegalArgumentException("event cannot be null or empty.");
            }
            this.event = event;
        }

        public Builder properties(Map<String, ?> properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = ImmutableMap.copyOf(properties);
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        protected TrackMessage realBuild(Message.Type type, String messageId, Date timestamp, Map<String, ?> context, String anonymousId, String userId, Map<String, Object> integrations) {
            return new AutoValue_TrackMessage(type, messageId, timestamp, context, anonymousId, userId, integrations, this.event, this.properties);
        }
    }
}

