/*
 * Decompiled with CFR 0.152.
 */
package com.rudderstack.sdk.java.messages;

import com.google.auto.value.AutoValue;
import com.rudderstack.sdk.java.gson.AutoGson;
import com.rudderstack.sdk.java.messages.AutoValue_PageMessage;
import com.rudderstack.sdk.java.messages.ImmutableMap;
import com.rudderstack.sdk.java.messages.Message;
import com.rudderstack.sdk.java.messages.MessageBuilder;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

@AutoGson
@AutoValue
public abstract class PageMessage
implements Message {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public abstract String name();

    @Nullable
    public abstract Map<String, ?> properties();

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends MessageBuilder<PageMessage, Builder> {
        private String name;
        private Map<String, ?> properties;

        private Builder(PageMessage page) {
            super(page);
            this.name = page.name();
            this.properties = page.properties();
        }

        private Builder(String name) {
            super(Message.Type.page);
            if (Builder.isNullOrEmpty(name)) {
                throw new IllegalArgumentException("page name cannot be null or empty.");
            }
            this.name = name;
        }

        public Builder properties(Map<String, ?> properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = ImmutableMap.copyOf(properties);
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        protected PageMessage realBuild(Message.Type type, String messageId, Date timestamp, Map<String, ?> context, String anonymousId, String userId, Map<String, Object> integrations) {
            return new AutoValue_PageMessage(type, messageId, timestamp, context, anonymousId, userId, integrations, this.name, this.properties);
        }
    }
}

