/*
 * Decompiled with CFR 0.152.
 */
package com.rudderstack.sdk.java.internal;

import com.rudderstack.sdk.java.Callback;
import com.rudderstack.sdk.java.Log;
import com.rudderstack.sdk.java.http.RudderService;
import com.rudderstack.sdk.java.internal.FlushMessage;
import com.rudderstack.sdk.java.messages.Batch;
import com.rudderstack.sdk.java.messages.Message;
import com.segment.backo.Backo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import retrofit.RetrofitError;

public class AnalyticsClient {
    private static final Map<String, ?> CONTEXT;
    private final BlockingQueue<Message> messageQueue;
    private final RudderService service;
    private final int size;
    private final Log log;
    private final List<Callback> callbacks;
    private final ExecutorService networkExecutor;
    private final ExecutorService looperExecutor;
    private final ScheduledExecutorService flushScheduler;

    public static AnalyticsClient create(RudderService rudderService, int flushQueueSize, long flushIntervalInMillis, Log log, ThreadFactory threadFactory, ExecutorService networkExecutor, List<Callback> callbacks) {
        return new AnalyticsClient(new LinkedBlockingQueue<Message>(), rudderService, flushQueueSize, flushIntervalInMillis, log, threadFactory, networkExecutor, callbacks);
    }

    AnalyticsClient(BlockingQueue<Message> messageQueue, RudderService service, int maxQueueSize, long flushIntervalInMillis, Log log, ThreadFactory threadFactory, ExecutorService networkExecutor, List<Callback> callbacks) {
        this.messageQueue = messageQueue;
        this.service = service;
        this.size = maxQueueSize;
        this.log = log;
        this.callbacks = callbacks;
        this.looperExecutor = Executors.newSingleThreadExecutor(threadFactory);
        this.networkExecutor = networkExecutor;
        this.looperExecutor.submit(new Looper());
        this.flushScheduler = Executors.newScheduledThreadPool(1, threadFactory);
        this.flushScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AnalyticsClient.this.flush();
            }
        }, flushIntervalInMillis, flushIntervalInMillis, TimeUnit.MILLISECONDS);
    }

    public void enqueue(Message message) {
        try {
            this.messageQueue.put(message);
        }
        catch (InterruptedException e) {
            this.log.print(Log.Level.ERROR, e, "Interrupted while adding message %s.", message);
        }
    }

    public void flush() {
        this.enqueue(FlushMessage.POISON);
    }

    public void shutdown() {
        this.messageQueue.clear();
        this.looperExecutor.shutdownNow();
        this.flushScheduler.shutdownNow();
        this.networkExecutor.shutdown();
    }

    static {
        LinkedHashMap<String, String> library = new LinkedHashMap<String, String>();
        library.put("name", "rudder-sdk-java");
        library.put("version", "1.0.1");
        LinkedHashMap context = new LinkedHashMap();
        context.put("library", Collections.unmodifiableMap(library));
        CONTEXT = Collections.unmodifiableMap(context);
    }

    class Looper
    implements Runnable {
        Looper() {
        }

        @Override
        public void run() {
            ArrayList<Message> messages = new ArrayList<Message>();
            try {
                while (true) {
                    Message message;
                    if ((message = (Message)AnalyticsClient.this.messageQueue.take()) != FlushMessage.POISON) {
                        messages.add(message);
                    } else if (messages.size() < 1) {
                        AnalyticsClient.this.log.print(Log.Level.VERBOSE, "No messages to flush.", new Object[0]);
                        continue;
                    }
                    if (messages.size() < AnalyticsClient.this.size && message != FlushMessage.POISON) continue;
                    Batch batch = Batch.create(CONTEXT, messages);
                    AnalyticsClient.this.log.print(Log.Level.VERBOSE, "Batching %s message(s) into batch %s.", messages.size(), batch.sequence());
                    AnalyticsClient.this.networkExecutor.submit(BatchUploadTask.create(AnalyticsClient.this, batch));
                    messages = new ArrayList();
                }
            }
            catch (InterruptedException e) {
                AnalyticsClient.this.log.print(Log.Level.DEBUG, "Looper interrupted while polling for messages.", new Object[0]);
                return;
            }
        }
    }

    static class BatchUploadTask
    implements Runnable {
        private static final Backo BACKO = Backo.builder().base(TimeUnit.SECONDS, 15L).cap(TimeUnit.HOURS, 1L).jitter(1).build();
        private static final int MAX_ATTEMPTS = 50;
        private final AnalyticsClient client;
        private final Backo backo;
        final Batch batch;

        static BatchUploadTask create(AnalyticsClient client, Batch batch) {
            return new BatchUploadTask(client, BACKO, batch);
        }

        BatchUploadTask(AnalyticsClient client, Backo backo, Batch batch) {
            this.client = client;
            this.batch = batch;
            this.backo = backo;
        }

        boolean upload() {
            try {
                this.client.log.print(Log.Level.VERBOSE, "Uploading batch %s.", this.batch.sequence());
                this.client.service.upload(this.batch);
                this.client.log.print(Log.Level.VERBOSE, "Uploaded batch %s.", this.batch.sequence());
                for (Message message : this.batch.batch()) {
                    for (Callback callback : this.client.callbacks) {
                        callback.success(message);
                    }
                }
                return false;
            }
            catch (RetrofitError error) {
                switch (error.getKind()) {
                    case NETWORK: {
                        this.client.log.print(Log.Level.DEBUG, error, "Could not upload batch %s. Retrying.", this.batch.sequence());
                        return true;
                    }
                    case HTTP: {
                        int status = error.getResponse().getStatus();
                        if (BatchUploadTask.is5xx(status)) {
                            this.client.log.print(Log.Level.DEBUG, error, "Could not upload batch %s due to server error. Retrying.", this.batch.sequence());
                            return true;
                        }
                        if (status == 429) {
                            this.client.log.print(Log.Level.DEBUG, error, "Could not upload batch %s due to rate limiting. Retrying.", this.batch.sequence());
                            return true;
                        }
                        this.client.log.print(Log.Level.ERROR, error, "Could not upload batch %s due to HTTP error. Giving up.", this.batch.sequence());
                        for (Message message : this.batch.batch()) {
                            for (Callback callback : this.client.callbacks) {
                                callback.failure(message, error);
                            }
                        }
                        return false;
                    }
                }
                this.client.log.print(Log.Level.ERROR, error, "Could not upload batch %s. Giving up.", this.batch.sequence());
                for (Message message : this.batch.batch()) {
                    for (Callback callback : this.client.callbacks) {
                        callback.failure(message, error);
                    }
                }
                return false;
            }
        }

        @Override
        public void run() {
            for (int attempt = 0; attempt < 50; ++attempt) {
                boolean retry = this.upload();
                if (!retry) {
                    return;
                }
                try {
                    this.backo.sleep(attempt);
                    continue;
                }
                catch (InterruptedException e) {
                    this.client.log.print(Log.Level.DEBUG, "Thread interrupted while backing off for batch %s.", this.batch.sequence());
                    return;
                }
            }
            this.client.log.print(Log.Level.ERROR, "Could not upload batch %s. Retries exhausted.", this.batch.sequence());
            IOException exception = new IOException("50 retries exhausted");
            for (Message message : this.batch.batch()) {
                for (Callback callback : this.client.callbacks) {
                    callback.failure(message, exception);
                }
            }
        }

        private static boolean is5xx(int status) {
            return status >= 500 && status < 600;
        }
    }
}

