/*
 * Decompiled with CFR 0.152.
 */
package com.rudderstack.sdk.java;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.rudderstack.sdk.java.AnalyticsRequestInterceptor;
import com.rudderstack.sdk.java.Callback;
import com.rudderstack.sdk.java.FlushBlocking;
import com.rudderstack.sdk.java.Log;
import com.rudderstack.sdk.java.MessageInterceptor;
import com.rudderstack.sdk.java.MessageTransformer;
import com.rudderstack.sdk.java.Platform;
import com.rudderstack.sdk.java.Plugin;
import com.rudderstack.sdk.java.gson.AutoValueAdapterFactory;
import com.rudderstack.sdk.java.gson.ISO8601DateAdapter;
import com.rudderstack.sdk.java.http.RudderService;
import com.rudderstack.sdk.java.internal.AnalyticsClient;
import com.rudderstack.sdk.java.messages.Message;
import com.rudderstack.sdk.java.messages.MessageBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import retrofit.Endpoint;
import retrofit.Endpoints;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class RudderAnalytics {
    private final AnalyticsClient client;
    private final List<MessageTransformer> messageTransformers;
    private final List<MessageInterceptor> messageInterceptors;
    private final Log log;
    private static FlushBlocking flushBlock = null;

    RudderAnalytics(AnalyticsClient client, List<MessageTransformer> messageTransformers, List<MessageInterceptor> messageInterceptors, Log log) {
        this.client = client;
        this.messageTransformers = messageTransformers;
        this.messageInterceptors = messageInterceptors;
        this.log = log;
    }

    public static Builder builder(String writeKey, String dataPlaneUrl) {
        return new Builder(writeKey, dataPlaneUrl);
    }

    public void enqueue(MessageBuilder builder) {
        for (MessageTransformer messageTransformer : this.messageTransformers) {
            boolean shouldContinue = messageTransformer.transform(builder);
            if (shouldContinue) continue;
            this.log.print(Log.Level.VERBOSE, "Skipping message %s.", builder);
            return;
        }
        Object message = builder.build();
        for (MessageInterceptor messageInterceptor : this.messageInterceptors) {
            message = messageInterceptor.intercept((Message)message);
            if (message != null) continue;
            this.log.print(Log.Level.VERBOSE, "Skipping message %s.", builder);
            return;
        }
        this.client.enqueue((Message)message);
    }

    public void flush() {
        this.client.flush();
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public synchronized void blockFlush() {
        this.flush();
        flushBlock.block();
    }

    public static class Builder {
        private static final Endpoint DEFAULT_ENDPOINT = Endpoints.newFixedEndpoint((String)"https://hosted.rudderlabs.com");
        private static final String DEFAULT_USER_AGENT = "rudderstack-analytics-java/1.0.1";
        private final String writeKey;
        private Client client;
        private Log log;
        private Endpoint endpoint;
        private String userAgent = "rudderstack-analytics-java/1.0.1";
        private List<MessageTransformer> messageTransformers;
        private List<MessageInterceptor> messageInterceptors;
        private ExecutorService networkExecutor;
        private ThreadFactory threadFactory;
        private int flushQueueSize;
        private long flushIntervalInMillis;
        private List<Callback> callbacks;

        Builder(String writeKey, String dataPlaneUrl) {
            if (writeKey == null || writeKey.trim().length() == 0 || dataPlaneUrl == null || dataPlaneUrl.trim().length() == 0) {
                throw new NullPointerException("writeKey cannot be null or empty.");
            }
            this.writeKey = writeKey;
            this.endpoint = Endpoints.newFixedEndpoint((String)dataPlaneUrl);
        }

        public Builder client(Client client) {
            if (client == null) {
                throw new NullPointerException("Null client");
            }
            this.client = client;
            return this;
        }

        public Builder log(Log log) {
            if (log == null) {
                throw new NullPointerException("Null log");
            }
            this.log = log;
            return this;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint == null || endpoint.trim().length() == 0) {
                throw new NullPointerException("endpoint cannot be null or empty.");
            }
            this.endpoint = Endpoints.newFixedEndpoint((String)(endpoint + "/v1/batch"));
            return this;
        }

        public Builder userAgent(String userAgent) {
            if (userAgent == null || userAgent.trim().length() == 0) {
                throw new NullPointerException("userAgent cannot be null or empty.");
            }
            this.userAgent = userAgent;
            return this;
        }

        public Builder messageTransformer(MessageTransformer transformer) {
            if (transformer == null) {
                throw new NullPointerException("Null transformer");
            }
            if (this.messageTransformers == null) {
                this.messageTransformers = new ArrayList<MessageTransformer>();
            }
            if (this.messageTransformers.contains(transformer)) {
                throw new IllegalStateException("MessageTransformer is already registered.");
            }
            this.messageTransformers.add(transformer);
            return this;
        }

        public Builder messageInterceptor(MessageInterceptor interceptor) {
            if (interceptor == null) {
                throw new NullPointerException("Null interceptor");
            }
            if (this.messageInterceptors == null) {
                this.messageInterceptors = new ArrayList<MessageInterceptor>();
            }
            if (this.messageInterceptors.contains(interceptor)) {
                throw new IllegalStateException("MessageInterceptor is already registered.");
            }
            this.messageInterceptors.add(interceptor);
            return this;
        }

        public Builder flushQueueSize(int flushQueueSize) {
            if (flushQueueSize < 1) {
                throw new IllegalArgumentException("flushQueueSize must not be less than 1.");
            }
            this.flushQueueSize = flushQueueSize;
            return this;
        }

        public Builder flushInterval(long flushInterval, TimeUnit unit) {
            long flushIntervalInMillis = unit.toMillis(flushInterval);
            if (flushIntervalInMillis < 1000L) {
                throw new IllegalArgumentException("flushInterval must not be less than 1 second.");
            }
            this.flushIntervalInMillis = flushIntervalInMillis;
            return this;
        }

        public Builder networkExecutor(ExecutorService networkExecutor) {
            if (networkExecutor == null) {
                throw new NullPointerException("Null networkExecutor");
            }
            this.networkExecutor = networkExecutor;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            if (threadFactory == null) {
                throw new NullPointerException("Null threadFactory");
            }
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder callback(Callback callback) {
            if (callback == null) {
                throw new NullPointerException("Null callback");
            }
            if (this.callbacks == null) {
                this.callbacks = new ArrayList<Callback>();
            }
            if (this.callbacks.contains(callback)) {
                throw new IllegalStateException("Callback is already registered.");
            }
            this.callbacks.add(callback);
            return this;
        }

        public Builder plugin(Plugin plugin) {
            if (plugin == null) {
                throw new NullPointerException("Null plugin");
            }
            plugin.configure(this);
            return this;
        }

        public Builder synchronize(boolean isSynchronize) {
            if (isSynchronize) {
                flushBlock = FlushBlocking.create();
                this.plugin(flushBlock.plugin());
            }
            return this;
        }

        public RudderAnalytics build() {
            Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new AutoValueAdapterFactory()).registerTypeAdapter(Date.class, (Object)new ISO8601DateAdapter()).create();
            if (this.endpoint == null) {
                this.endpoint = DEFAULT_ENDPOINT;
            }
            if (this.client == null) {
                this.client = Platform.get().defaultClient();
            }
            if (this.log == null) {
                this.log = Log.NONE;
            }
            if (this.flushIntervalInMillis == 0L) {
                this.flushIntervalInMillis = Platform.get().defaultFlushIntervalInMillis();
            }
            if (this.flushQueueSize == 0) {
                this.flushQueueSize = Platform.get().defaultFlushQueueSize();
            }
            this.messageTransformers = this.messageTransformers == null ? Collections.emptyList() : Collections.unmodifiableList(this.messageTransformers);
            this.messageInterceptors = this.messageInterceptors == null ? Collections.emptyList() : Collections.unmodifiableList(this.messageInterceptors);
            if (this.networkExecutor == null) {
                this.networkExecutor = Platform.get().defaultNetworkExecutor();
            }
            if (this.threadFactory == null) {
                this.threadFactory = Platform.get().defaultThreadFactory();
            }
            this.callbacks = this.callbacks == null ? Collections.emptyList() : Collections.unmodifiableList(this.callbacks);
            RestAdapter restAdapter = new RestAdapter.Builder().setConverter((Converter)new GsonConverter(gson)).setEndpoint(this.endpoint).setClient(this.client).setRequestInterceptor((RequestInterceptor)new AnalyticsRequestInterceptor(this.writeKey, this.userAgent)).setLogLevel(RestAdapter.LogLevel.FULL).setLog(new RestAdapter.Log(){

                public void log(String message) {
                    Builder.this.log.print(Log.Level.VERBOSE, "%s", message);
                }
            }).build();
            RudderService rudderService = (RudderService)restAdapter.create(RudderService.class);
            AnalyticsClient analyticsClient = AnalyticsClient.create(rudderService, this.flushQueueSize, this.flushIntervalInMillis, this.log, this.threadFactory, this.networkExecutor, this.callbacks);
            return new RudderAnalytics(analyticsClient, this.messageTransformers, this.messageInterceptors, this.log);
        }
    }
}

