/*
 * Decompiled with CFR 0.152.
 */
package com.rudderstack.sdk.java;

import com.rudderstack.sdk.java.messages.AliasMessage;
import com.rudderstack.sdk.java.messages.GroupMessage;
import com.rudderstack.sdk.java.messages.IdentifyMessage;
import com.rudderstack.sdk.java.messages.Message;
import com.rudderstack.sdk.java.messages.MessageBuilder;
import com.rudderstack.sdk.java.messages.PageMessage;
import com.rudderstack.sdk.java.messages.ScreenMessage;
import com.rudderstack.sdk.java.messages.TrackMessage;

public interface MessageTransformer {
    public boolean transform(MessageBuilder var1);

    public static abstract class Typed
    implements MessageTransformer {
        @Override
        public final boolean transform(MessageBuilder builder) {
            Message.Type type = builder.type();
            switch (type) {
                case alias: {
                    return this.alias((AliasMessage.Builder)builder);
                }
                case group: {
                    return this.group((GroupMessage.Builder)builder);
                }
                case identify: {
                    return this.identify((IdentifyMessage.Builder)builder);
                }
                case screen: {
                    return this.screen((ScreenMessage.Builder)builder);
                }
                case page: {
                    return this.page((PageMessage.Builder)builder);
                }
                case track: {
                    return this.track((TrackMessage.Builder)builder);
                }
            }
            throw new IllegalArgumentException("Unknown payload type: " + (Object)((Object)type));
        }

        abstract boolean alias(AliasMessage.Builder var1);

        abstract boolean group(GroupMessage.Builder var1);

        abstract boolean identify(IdentifyMessage.Builder var1);

        abstract boolean screen(ScreenMessage.Builder var1);

        abstract boolean page(PageMessage.Builder var1);

        abstract boolean track(TrackMessage.Builder var1);
    }
}

