/*
 * Decompiled with CFR 0.152.
 */
package com.rudderstack.sdk.java;

import com.rudderstack.sdk.java.messages.AliasMessage;
import com.rudderstack.sdk.java.messages.GroupMessage;
import com.rudderstack.sdk.java.messages.IdentifyMessage;
import com.rudderstack.sdk.java.messages.Message;
import com.rudderstack.sdk.java.messages.PageMessage;
import com.rudderstack.sdk.java.messages.ScreenMessage;
import com.rudderstack.sdk.java.messages.TrackMessage;

public interface MessageInterceptor {
    public Message intercept(Message var1);

    public static abstract class Typed
    implements MessageInterceptor {
        @Override
        public final Message intercept(Message message) {
            Message.Type type = message.type();
            switch (type) {
                case alias: {
                    return this.alias((AliasMessage)message);
                }
                case group: {
                    return this.group((GroupMessage)message);
                }
                case identify: {
                    return this.identify((IdentifyMessage)message);
                }
                case screen: {
                    return this.screen((ScreenMessage)message);
                }
                case page: {
                    return this.page((PageMessage)message);
                }
                case track: {
                    return this.track((TrackMessage)message);
                }
            }
            throw new IllegalArgumentException("Unknown payload type: " + (Object)((Object)type));
        }

        abstract AliasMessage alias(AliasMessage var1);

        abstract GroupMessage group(GroupMessage var1);

        abstract IdentifyMessage identify(IdentifyMessage var1);

        abstract ScreenMessage screen(ScreenMessage var1);

        abstract PageMessage page(PageMessage var1);

        abstract TrackMessage track(TrackMessage var1);
    }
}

