/*
 * Decompiled with CFR 0.152.
 */
package com.rudderstack.sdk.java;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AnalyticsResponseInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (response.code() == 200) {
            HashMap<String, String> jsonResponse = new HashMap<String, String>();
            jsonResponse.put("response", response.body() == null ? "error" : response.body().string());
            MediaType contentType = MediaType.parse((String)"application/json");
            ResponseBody body = ResponseBody.create((MediaType)contentType, (String)new Gson().toJson(jsonResponse));
            return response.newBuilder().body(body).build();
        }
        if (response.code() == 403) {
            HashMap<String, String> jsonResponse = new HashMap<String, String>();
            jsonResponse.put("response", "error");
            MediaType contentType = MediaType.parse((String)"application/json");
            ResponseBody body = ResponseBody.create((MediaType)contentType, (String)new Gson().toJson(jsonResponse));
            return response.newBuilder().body(body).build();
        }
        return response;
    }
}

