/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.geo;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.util.ObjectUtils;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import redis.clients.jedis.search.querybuilder.GeoValue;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;

public class OutsideOfPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final Point point;
    private final Distance distance;

    public OutsideOfPredicate(SearchFieldAccessor field, Point point, Distance distance) {
        super(field);
        this.point = point;
        this.distance = distance;
    }

    public Point getPoint() {
        return this.point;
    }

    public Distance getDistance() {
        return this.distance;
    }

    @Override
    public Node apply(Node root) {
        GeoValue geoValue = new GeoValue(this.getPoint().getX(), this.getPoint().getY(), this.getDistance().getValue(), ObjectUtils.getDistanceUnit(this.getDistance()));
        return QueryBuilders.intersect((Node[])new Node[]{root}).add(new Node[]{QueryBuilders.disjunct((String)this.getSearchAlias(), (Value[])new Value[]{geoValue})});
    }
}

