/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.fulltext;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import java.util.List;
import java.util.StringJoiner;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;

public class InPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final List<T> values;

    public InPredicate(SearchFieldAccessor field, List<T> values) {
        super(field);
        this.values = values;
    }

    public List<T> getValues() {
        return this.values;
    }

    @Override
    public Node apply(Node root) {
        StringJoiner sj = new StringJoiner(" | ");
        for (T value : this.getValues()) {
            sj.add(QueryUtils.escape(value.toString(), true));
        }
        return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new String[]{sj.toString()});
    }
}

