/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.audit;

import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.redis.core.RedisOperations;

public class EntityAuditor {
    private final RedisOperations<?, ?> redisOperations;

    public EntityAuditor(RedisOperations<?, ?> redisOperations) {
        this.redisOperations = redisOperations;
    }

    public void processEntity(byte[] redisKey, Object item) {
        boolean isNew = (Boolean)this.redisOperations.execute(connection -> connection.keyCommands().exists(redisKey) == false);
        this.processEntity(item, isNew);
    }

    public void processEntity(Object item, boolean isNew) {
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> EntityAuditor.lambda$processEntity$1((PropertyAccessor)accessor, arg_0));
        }
    }

    private static /* synthetic */ void lambda$processEntity$1(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }
}

