/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import jakarta.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="redis.om.spring", ignoreInvalidFields=true)
public class RedisOMSpringProperties {
    private final Repository repository = new Repository();
    private final Djl djl = new Djl();

    public Repository getRepository() {
        return this.repository;
    }

    public Djl getDjl() {
        return this.djl;
    }

    public static class Repository {
        private final Query query = new Query();

        public Query getQuery() {
            return this.query;
        }

        public static class Query {
            private int limit = 10000;

            public int getLimit() {
                return this.limit;
            }

            public void setLimit(int limit) {
                this.limit = limit;
            }
        }
    }

    public static class Djl {
        private static final String DEFAULT_ENGINE = "PyTorch";
        @NotNull
        private String imageEmbeddingModelEngine = "PyTorch";
        @NotNull
        private String imageEmbeddingModelModelUrls = "djl://ai.djl.pytorch/resnet18_embedding";
        @NotNull
        private int defaultImagePipelineResizeWidth = 224;
        @NotNull
        private int defaultImagePipelineResizeHeight = 224;
        @NotNull
        private boolean defaultImagePipelineCenterCrop = true;
        @NotNull
        private String sentenceTokenizerMaxLength = "768";
        @NotNull
        private String sentenceTokenizerModelMaxLength = "768";
        @NotNull
        private String sentenceTokenizerModel = "sentence-transformers/all-mpnet-base-v2";
        @NotNull
        private String faceDetectionModelEngine = "PyTorch";
        @NotNull
        private String faceDetectionModelName = "retinaface";
        @NotNull
        private String faceDetectionModelModelUrls = "https://resources.djl.ai/test-models/pytorch/retinaface.zip";
        @NotNull
        private String faceEmbeddingModelEngine = "PyTorch";
        @NotNull
        private String faceEmbeddingModelName = "face_feature";
        @NotNull
        private String faceEmbeddingModelModelUrls = "https://resources.djl.ai/test-models/pytorch/face_feature.zip";

        public String getImageEmbeddingModelEngine() {
            return this.imageEmbeddingModelEngine;
        }

        public String getImageEmbeddingModelModelUrls() {
            return this.imageEmbeddingModelModelUrls;
        }

        public int getDefaultImagePipelineResizeWidth() {
            return this.defaultImagePipelineResizeWidth;
        }

        public int getDefaultImagePipelineResizeHeight() {
            return this.defaultImagePipelineResizeHeight;
        }

        public boolean isDefaultImagePipelineCenterCrop() {
            return this.defaultImagePipelineCenterCrop;
        }

        public String getSentenceTokenizerMaxLength() {
            return this.sentenceTokenizerMaxLength;
        }

        public String getSentenceTokenizerModelMaxLength() {
            return this.sentenceTokenizerModelMaxLength;
        }

        public String getSentenceTokenizerModel() {
            return this.sentenceTokenizerModel;
        }

        public String getFaceDetectionModelEngine() {
            return this.faceDetectionModelEngine;
        }

        public String getFaceDetectionModelName() {
            return this.faceDetectionModelName;
        }

        public String getFaceDetectionModelModelUrls() {
            return this.faceDetectionModelModelUrls;
        }

        public String getFaceEmbeddingModelEngine() {
            return this.faceEmbeddingModelEngine;
        }

        public String getFaceEmbeddingModelName() {
            return this.faceEmbeddingModelName;
        }

        public String getFaceEmbeddingModelModelUrls() {
            return this.faceEmbeddingModelModelUrls;
        }

        public void setImageEmbeddingModelEngine(String imageEmbeddingModelEngine) {
            this.imageEmbeddingModelEngine = imageEmbeddingModelEngine;
        }

        public void setImageEmbeddingModelModelUrls(String imageEmbeddingModelModelUrls) {
            this.imageEmbeddingModelModelUrls = imageEmbeddingModelModelUrls;
        }

        public void setDefaultImagePipelineResizeWidth(int defaultImagePipelineResizeWidth) {
            this.defaultImagePipelineResizeWidth = defaultImagePipelineResizeWidth;
        }

        public void setDefaultImagePipelineResizeHeight(int defaultImagePipelineResizeHeight) {
            this.defaultImagePipelineResizeHeight = defaultImagePipelineResizeHeight;
        }

        public void setDefaultImagePipelineCenterCrop(boolean defaultImagePipelineCenterCrop) {
            this.defaultImagePipelineCenterCrop = defaultImagePipelineCenterCrop;
        }

        public void setSentenceTokenizerMaxLength(String sentenceTokenizerMaxLength) {
            this.sentenceTokenizerMaxLength = sentenceTokenizerMaxLength;
        }

        public void setSentenceTokenizerModelMaxLength(String sentenceTokenizerModelMaxLength) {
            this.sentenceTokenizerModelMaxLength = sentenceTokenizerModelMaxLength;
        }

        public void setSentenceTokenizerModel(String sentenceTokenizerModel) {
            this.sentenceTokenizerModel = sentenceTokenizerModel;
        }

        public void setFaceDetectionModelEngine(String faceDetectionModelEngine) {
            this.faceDetectionModelEngine = faceDetectionModelEngine;
        }

        public void setFaceDetectionModelName(String faceDetectionModelName) {
            this.faceDetectionModelName = faceDetectionModelName;
        }

        public void setFaceDetectionModelModelUrls(String faceDetectionModelModelUrls) {
            this.faceDetectionModelModelUrls = faceDetectionModelModelUrls;
        }

        public void setFaceEmbeddingModelEngine(String faceEmbeddingModelEngine) {
            this.faceEmbeddingModelEngine = faceEmbeddingModelEngine;
        }

        public void setFaceEmbeddingModelName(String faceEmbeddingModelName) {
            this.faceEmbeddingModelName = faceEmbeddingModelName;
        }

        public void setFaceEmbeddingModelModelUrls(String faceEmbeddingModelModelUrls) {
            this.faceEmbeddingModelModelUrls = faceEmbeddingModelModelUrls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Djl)) {
                return false;
            }
            Djl other = (Djl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDefaultImagePipelineResizeWidth() != other.getDefaultImagePipelineResizeWidth()) {
                return false;
            }
            if (this.getDefaultImagePipelineResizeHeight() != other.getDefaultImagePipelineResizeHeight()) {
                return false;
            }
            if (this.isDefaultImagePipelineCenterCrop() != other.isDefaultImagePipelineCenterCrop()) {
                return false;
            }
            String this$imageEmbeddingModelEngine = this.getImageEmbeddingModelEngine();
            String other$imageEmbeddingModelEngine = other.getImageEmbeddingModelEngine();
            if (this$imageEmbeddingModelEngine == null ? other$imageEmbeddingModelEngine != null : !this$imageEmbeddingModelEngine.equals(other$imageEmbeddingModelEngine)) {
                return false;
            }
            String this$imageEmbeddingModelModelUrls = this.getImageEmbeddingModelModelUrls();
            String other$imageEmbeddingModelModelUrls = other.getImageEmbeddingModelModelUrls();
            if (this$imageEmbeddingModelModelUrls == null ? other$imageEmbeddingModelModelUrls != null : !this$imageEmbeddingModelModelUrls.equals(other$imageEmbeddingModelModelUrls)) {
                return false;
            }
            String this$sentenceTokenizerMaxLength = this.getSentenceTokenizerMaxLength();
            String other$sentenceTokenizerMaxLength = other.getSentenceTokenizerMaxLength();
            if (this$sentenceTokenizerMaxLength == null ? other$sentenceTokenizerMaxLength != null : !this$sentenceTokenizerMaxLength.equals(other$sentenceTokenizerMaxLength)) {
                return false;
            }
            String this$sentenceTokenizerModelMaxLength = this.getSentenceTokenizerModelMaxLength();
            String other$sentenceTokenizerModelMaxLength = other.getSentenceTokenizerModelMaxLength();
            if (this$sentenceTokenizerModelMaxLength == null ? other$sentenceTokenizerModelMaxLength != null : !this$sentenceTokenizerModelMaxLength.equals(other$sentenceTokenizerModelMaxLength)) {
                return false;
            }
            String this$sentenceTokenizerModel = this.getSentenceTokenizerModel();
            String other$sentenceTokenizerModel = other.getSentenceTokenizerModel();
            if (this$sentenceTokenizerModel == null ? other$sentenceTokenizerModel != null : !this$sentenceTokenizerModel.equals(other$sentenceTokenizerModel)) {
                return false;
            }
            String this$faceDetectionModelEngine = this.getFaceDetectionModelEngine();
            String other$faceDetectionModelEngine = other.getFaceDetectionModelEngine();
            if (this$faceDetectionModelEngine == null ? other$faceDetectionModelEngine != null : !this$faceDetectionModelEngine.equals(other$faceDetectionModelEngine)) {
                return false;
            }
            String this$faceDetectionModelName = this.getFaceDetectionModelName();
            String other$faceDetectionModelName = other.getFaceDetectionModelName();
            if (this$faceDetectionModelName == null ? other$faceDetectionModelName != null : !this$faceDetectionModelName.equals(other$faceDetectionModelName)) {
                return false;
            }
            String this$faceDetectionModelModelUrls = this.getFaceDetectionModelModelUrls();
            String other$faceDetectionModelModelUrls = other.getFaceDetectionModelModelUrls();
            if (this$faceDetectionModelModelUrls == null ? other$faceDetectionModelModelUrls != null : !this$faceDetectionModelModelUrls.equals(other$faceDetectionModelModelUrls)) {
                return false;
            }
            String this$faceEmbeddingModelEngine = this.getFaceEmbeddingModelEngine();
            String other$faceEmbeddingModelEngine = other.getFaceEmbeddingModelEngine();
            if (this$faceEmbeddingModelEngine == null ? other$faceEmbeddingModelEngine != null : !this$faceEmbeddingModelEngine.equals(other$faceEmbeddingModelEngine)) {
                return false;
            }
            String this$faceEmbeddingModelName = this.getFaceEmbeddingModelName();
            String other$faceEmbeddingModelName = other.getFaceEmbeddingModelName();
            if (this$faceEmbeddingModelName == null ? other$faceEmbeddingModelName != null : !this$faceEmbeddingModelName.equals(other$faceEmbeddingModelName)) {
                return false;
            }
            String this$faceEmbeddingModelModelUrls = this.getFaceEmbeddingModelModelUrls();
            String other$faceEmbeddingModelModelUrls = other.getFaceEmbeddingModelModelUrls();
            return !(this$faceEmbeddingModelModelUrls == null ? other$faceEmbeddingModelModelUrls != null : !this$faceEmbeddingModelModelUrls.equals(other$faceEmbeddingModelModelUrls));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Djl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDefaultImagePipelineResizeWidth();
            result = result * 59 + this.getDefaultImagePipelineResizeHeight();
            result = result * 59 + (this.isDefaultImagePipelineCenterCrop() ? 79 : 97);
            String $imageEmbeddingModelEngine = this.getImageEmbeddingModelEngine();
            result = result * 59 + ($imageEmbeddingModelEngine == null ? 43 : $imageEmbeddingModelEngine.hashCode());
            String $imageEmbeddingModelModelUrls = this.getImageEmbeddingModelModelUrls();
            result = result * 59 + ($imageEmbeddingModelModelUrls == null ? 43 : $imageEmbeddingModelModelUrls.hashCode());
            String $sentenceTokenizerMaxLength = this.getSentenceTokenizerMaxLength();
            result = result * 59 + ($sentenceTokenizerMaxLength == null ? 43 : $sentenceTokenizerMaxLength.hashCode());
            String $sentenceTokenizerModelMaxLength = this.getSentenceTokenizerModelMaxLength();
            result = result * 59 + ($sentenceTokenizerModelMaxLength == null ? 43 : $sentenceTokenizerModelMaxLength.hashCode());
            String $sentenceTokenizerModel = this.getSentenceTokenizerModel();
            result = result * 59 + ($sentenceTokenizerModel == null ? 43 : $sentenceTokenizerModel.hashCode());
            String $faceDetectionModelEngine = this.getFaceDetectionModelEngine();
            result = result * 59 + ($faceDetectionModelEngine == null ? 43 : $faceDetectionModelEngine.hashCode());
            String $faceDetectionModelName = this.getFaceDetectionModelName();
            result = result * 59 + ($faceDetectionModelName == null ? 43 : $faceDetectionModelName.hashCode());
            String $faceDetectionModelModelUrls = this.getFaceDetectionModelModelUrls();
            result = result * 59 + ($faceDetectionModelModelUrls == null ? 43 : $faceDetectionModelModelUrls.hashCode());
            String $faceEmbeddingModelEngine = this.getFaceEmbeddingModelEngine();
            result = result * 59 + ($faceEmbeddingModelEngine == null ? 43 : $faceEmbeddingModelEngine.hashCode());
            String $faceEmbeddingModelName = this.getFaceEmbeddingModelName();
            result = result * 59 + ($faceEmbeddingModelName == null ? 43 : $faceEmbeddingModelName.hashCode());
            String $faceEmbeddingModelModelUrls = this.getFaceEmbeddingModelModelUrls();
            result = result * 59 + ($faceEmbeddingModelModelUrls == null ? 43 : $faceEmbeddingModelModelUrls.hashCode());
            return result;
        }

        public String toString() {
            return "RedisOMSpringProperties.Djl(imageEmbeddingModelEngine=" + this.getImageEmbeddingModelEngine() + ", imageEmbeddingModelModelUrls=" + this.getImageEmbeddingModelModelUrls() + ", defaultImagePipelineResizeWidth=" + this.getDefaultImagePipelineResizeWidth() + ", defaultImagePipelineResizeHeight=" + this.getDefaultImagePipelineResizeHeight() + ", defaultImagePipelineCenterCrop=" + this.isDefaultImagePipelineCenterCrop() + ", sentenceTokenizerMaxLength=" + this.getSentenceTokenizerMaxLength() + ", sentenceTokenizerModelMaxLength=" + this.getSentenceTokenizerModelMaxLength() + ", sentenceTokenizerModel=" + this.getSentenceTokenizerModel() + ", faceDetectionModelEngine=" + this.getFaceDetectionModelEngine() + ", faceDetectionModelName=" + this.getFaceDetectionModelName() + ", faceDetectionModelModelUrls=" + this.getFaceDetectionModelModelUrls() + ", faceEmbeddingModelEngine=" + this.getFaceEmbeddingModelEngine() + ", faceEmbeddingModelName=" + this.getFaceEmbeddingModelName() + ", faceEmbeddingModelModelUrls=" + this.getFaceEmbeddingModelModelUrls() + ")";
        }
    }
}

