/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import ai.djl.MalformedModelException;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import com.github.f4b6a3.ulid.Ulid;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redis.om.spring.CustomRedisKeyValueTemplate;
import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.RedisEnhancedKeyValueAdapter;
import com.redis.om.spring.RedisJSONKeyValueAdapter;
import com.redis.om.spring.RedisOMSpringProperties;
import com.redis.om.spring.annotations.Bloom;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.pds.BloomOperations;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.serialization.gson.DateTypeAdapter;
import com.redis.om.spring.serialization.gson.InstantTypeAdapter;
import com.redis.om.spring.serialization.gson.LocalDateTimeTypeAdapter;
import com.redis.om.spring.serialization.gson.LocalDateTypeAdapter;
import com.redis.om.spring.serialization.gson.OffsetDateTimeTypeAdapter;
import com.redis.om.spring.serialization.gson.PointTypeAdapter;
import com.redis.om.spring.serialization.gson.UlidTypeAdapter;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.FeatureExtractor;
import com.redis.om.spring.vectorize.face.FaceDetectionTranslator;
import com.redis.om.spring.vectorize.face.FaceFeatureTranslator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.gson.GsonBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class, RedisOMSpringProperties.class})
@EnableAspectJAutoProxy
@ComponentScans(value={@ComponentScan(value={"com.redis.om.spring.bloom"}), @ComponentScan(value={"com.redis.om.spring.autocomplete"}), @ComponentScan(value={"com.redis.om.spring.metamodel"})})
public class RedisModulesConfiguration {
    private static final Log logger = LogFactory.getLog(RedisModulesConfiguration.class);

    @Bean
    public GsonBuilder gsonBuilder(List<GsonBuilderCustomizer> customizers) {
        GsonBuilder builder = new GsonBuilder();
        customizers.forEach(c -> c.customize(builder));
        builder.registerTypeAdapter(Point.class, (Object)PointTypeAdapter.getInstance());
        builder.registerTypeAdapter(Date.class, (Object)DateTypeAdapter.getInstance());
        builder.registerTypeAdapter(LocalDate.class, (Object)LocalDateTypeAdapter.getInstance());
        builder.registerTypeAdapter(LocalDateTime.class, (Object)LocalDateTimeTypeAdapter.getInstance());
        builder.registerTypeAdapter(Ulid.class, (Object)UlidTypeAdapter.getInstance());
        builder.registerTypeAdapter(Instant.class, (Object)InstantTypeAdapter.getInstance());
        builder.registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter());
        return builder;
    }

    @Bean(name={"redisModulesClient"})
    RedisModulesClient redisModulesClient(JedisConnectionFactory jedisConnectionFactory, GsonBuilder builder) {
        return new RedisModulesClient(jedisConnectionFactory, builder);
    }

    @Bean(name={"redisModulesOperations"})
    @Primary
    @ConditionalOnMissingBean
    RedisModulesOperations<?> redisModulesOperations(RedisModulesClient rmc, StringRedisTemplate template, GsonBuilder gsonBuilder) {
        return new RedisModulesOperations(rmc, template, gsonBuilder);
    }

    @Bean(name={"redisJSONOperations"})
    JSONOperations<?> redisJSONOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForJSON();
    }

    @Bean(name={"redisBloomOperations"})
    BloomOperations<?> redisBloomOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForBloom();
    }

    @Bean(name={"redisTemplate"})
    @Primary
    public RedisTemplate<?, ?> redisTemplate(JedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setDefaultSerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory((RedisConnectionFactory)connectionFactory);
        return template;
    }

    @Bean(name={"rediSearchIndexer"})
    public RediSearchIndexer redisearchIndexer(ApplicationContext ac) {
        return new RediSearchIndexer(ac);
    }

    @Bean(name={"djlImageFactory"})
    public ImageFactory imageFactory() {
        return ImageFactory.getInstance();
    }

    @Bean(name={"djlImageEmbeddingModelCriteria"})
    public Criteria<Image, byte[]> imageEmbeddingModelCriteria(RedisOMSpringProperties properties) {
        return Criteria.builder().setTypes(Image.class, byte[].class).optEngine(properties.getDjl().getImageEmbeddingModelEngine()).optModelUrls(properties.getDjl().getImageEmbeddingModelModelUrls()).build();
    }

    @Bean(name={"djlFaceDetectionTranslator"})
    public Translator<Image, DetectedObjects> faceDetectionTranslator(RedisOMSpringProperties properties) {
        double confThresh = 0.85f;
        double nmsThresh = 0.45f;
        double[] variance = new double[]{0.1f, 0.2f};
        int topK = 5000;
        int[][] scales = new int[][]{{16, 32}, {64, 128}, {256, 512}};
        int[] steps = new int[]{8, 16, 32};
        return new FaceDetectionTranslator(confThresh, nmsThresh, variance, topK, scales, steps);
    }

    @Bean(name={"djlFaceDetectionModelCriteria"})
    public Criteria<Image, DetectedObjects> faceDetectionModelCriteria(@Qualifier(value="djlFaceDetectionTranslator") Translator<Image, DetectedObjects> translator, RedisOMSpringProperties properties) {
        return Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelUrls(properties.getDjl().getFaceDetectionModelModelUrls()).optModelName(properties.getDjl().getFaceDetectionModelName()).optTranslator(translator).optEngine(properties.getDjl().getFaceDetectionModelEngine()).build();
    }

    @Bean(name={"djlFaceDetectionModel"})
    public ZooModel<Image, DetectedObjects> faceDetectionModel(@Qualifier(value="djlFaceDetectionModelCriteria") Criteria<Image, DetectedObjects> criteria) {
        try {
            return ModelZoo.loadModel(criteria);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException ex) {
            logger.warn((Object)"Error retrieving default DJL face detection model", ex);
            return null;
        }
    }

    @Bean(name={"djlFaceEmbeddingTranslator"})
    public Translator<Image, float[]> faceEmbeddingTranslator(RedisOMSpringProperties properties) {
        return new FaceFeatureTranslator();
    }

    @Bean(name={"djlFaceEmbeddingModelCriteria"})
    public Criteria<Image, float[]> faceEmbeddingModelCriteria(@Qualifier(value="djlFaceEmbeddingTranslator") Translator<Image, float[]> translator, RedisOMSpringProperties properties) {
        return Criteria.builder().setTypes(Image.class, float[].class).optModelUrls(properties.getDjl().getFaceEmbeddingModelModelUrls()).optModelName(properties.getDjl().getFaceEmbeddingModelName()).optTranslator(translator).optEngine(properties.getDjl().getFaceEmbeddingModelEngine()).build();
    }

    @Bean(name={"djlFaceEmbeddingModel"})
    public ZooModel<Image, float[]> faceEmbeddingModel(@Qualifier(value="djlFaceEmbeddingModelCriteria") Criteria<Image, float[]> criteria) {
        try {
            return ModelZoo.loadModel(criteria);
        }
        catch (Exception e) {
            logger.warn((Object)"Error retrieving default DJL face embeddings model", (Throwable)e);
            return null;
        }
    }

    @Bean(name={"djlImageEmbeddingModel"})
    public ZooModel<Image, byte[]> imageModel(@Qualifier(value="djlImageEmbeddingModelCriteria") Criteria<Image, byte[]> criteria) throws MalformedModelException, ModelNotFoundException, IOException {
        return ModelZoo.loadModel(criteria);
    }

    @Bean(name={"djlDefaultImagePipeline"})
    public Pipeline defaultImagePipeline(RedisOMSpringProperties properties) {
        Pipeline pipeline = new Pipeline();
        if (properties.getDjl().isDefaultImagePipelineCenterCrop()) {
            pipeline.add((Transform)new CenterCrop());
        }
        return pipeline.add((Transform)new Resize(properties.getDjl().getDefaultImagePipelineResizeWidth(), properties.getDjl().getDefaultImagePipelineResizeHeight())).add((Transform)new ToTensor());
    }

    @Bean(name={"djlSentenceTokenizer"})
    public HuggingFaceTokenizer sentenceTokenizer(RedisOMSpringProperties properties) {
        Map<String, String> options = Map.of("maxLength", properties.getDjl().getSentenceTokenizerMaxLength(), "modelMaxLength", properties.getDjl().getSentenceTokenizerModelMaxLength());
        try {
            InetAddress.getByName("www.huggingface.co").isReachable(5000);
            return HuggingFaceTokenizer.newInstance((String)properties.getDjl().getSentenceTokenizerModel(), options);
        }
        catch (IOException ex) {
            logger.warn((Object)"Error retrieving default DJL sentence tokenizer");
            return null;
        }
    }

    @Bean(name={"featureExtractor"})
    public FeatureExtractor featureExtractor(@Nullable @Qualifier(value="djlImageEmbeddingModel") ZooModel<Image, byte[]> imageEmbeddingModel, @Nullable @Qualifier(value="djlFaceEmbeddingModel") ZooModel<Image, float[]> faceEmbeddingModel, @Nullable @Qualifier(value="djlImageFactory") ImageFactory imageFactory, @Nullable @Qualifier(value="djlDefaultImagePipeline") Pipeline defaultImagePipeline, @Nullable @Qualifier(value="djlSentenceTokenizer") HuggingFaceTokenizer sentenceTokenizer, @Nullable @Qualifier(value="redisTemplate") RedisTemplate<?, ?> redisTemplate, ApplicationContext ac) {
        return new FeatureExtractor((RedisOperations<?, ?>)redisTemplate, ac, imageEmbeddingModel, faceEmbeddingModel, imageFactory, defaultImagePipeline, sentenceTokenizer);
    }

    @Bean(name={"redisJSONKeyValueAdapter"})
    RedisJSONKeyValueAdapter getRedisJSONKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, RedisMappingContext mappingContext, RediSearchIndexer indexer, GsonBuilder gsonBuilder, RedisOMSpringProperties properties) {
        return new RedisJSONKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, gsonBuilder, properties);
    }

    @Bean(name={"redisJSONKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getRedisJSONKeyValueTemplate(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, RedisMappingContext mappingContext, RediSearchIndexer indexer, GsonBuilder gsonBuilder, RedisOMSpringProperties properties) {
        return new CustomRedisKeyValueTemplate(new RedisJSONKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, gsonBuilder, properties), mappingContext);
    }

    @Bean(name={"redisCustomKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getKeyValueTemplate(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, RedisMappingContext mappingContext, RediSearchIndexer indexer, FeatureExtractor featureExtractor) {
        return new CustomRedisKeyValueTemplate(new RedisEnhancedKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, indexer, featureExtractor), mappingContext);
    }

    @Bean(name={"streamingQueryBuilder"})
    EntityStream streamingQueryBuilder(RedisModulesOperations<?> redisModulesOperations, Gson gson) {
        return new EntityStreamImpl(redisModulesOperations, gson);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void ensureIndexesAreCreated(ContextRefreshedEvent cre) {
        logger.info((Object)"Creating Indexes......");
        ApplicationContext ac = cre.getApplicationContext();
        RediSearchIndexer indexer = (RediSearchIndexer)ac.getBean("rediSearchIndexer");
        indexer.createIndicesFor(Document.class);
        indexer.createIndicesFor(RedisHash.class);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void processBloom(ContextRefreshedEvent cre) {
        ApplicationContext ac = cre.getApplicationContext();
        RedisModulesOperations rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        Set<BeanDefinition> beanDefs = ObjectUtils.getBeanDefinitionsFor(ac, Document.class, RedisHash.class);
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                for (Field field : ObjectUtils.getDeclaredFieldsTransitively(cl)) {
                    if (!field.isAnnotationPresent(Bloom.class)) continue;
                    Bloom bloom = field.getAnnotation(Bloom.class);
                    BloomOperations<String> ops = rmo.opsForBloom();
                    String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bloom.name()) ? bloom.name() : String.format("bf:%s:%s", cl.getSimpleName(), field.getName());
                    ops.createFilter(filterName, bloom.capacity(), bloom.errorRate());
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Error during processing of @Bloom annotation: ", (Throwable)e);
            }
        }
    }
}

