/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.vectorize.face;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.transform.Normalize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;

public class FaceFeatureTranslator
implements Translator<Image, float[]> {
    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray array = input.toNDArray(ctx.getNDManager(), Image.Flag.COLOR);
        Pipeline pipeline = new Pipeline();
        pipeline.add((Transform)new ToTensor()).add((Transform)new Normalize(new float[]{0.5f, 0.5f, 0.5f}, new float[]{0.5019608f, 0.5019608f, 0.5019608f}));
        return pipeline.transform(new NDList(new NDArray[]{array}));
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        NDList result = new NDList();
        long numOutputs = list.singletonOrThrow().getShape().get(0);
        int i = 0;
        while ((long)i < numOutputs) {
            result.add((Object)list.singletonOrThrow().get(new long[]{i}));
            ++i;
        }
        float[][] embeddings = (float[][])result.stream().map(NDArray::toFloatArray).toArray(x$0 -> new float[x$0][]);
        float[] feature = new float[embeddings.length];
        for (int i2 = 0; i2 < embeddings.length; ++i2) {
            feature[i2] = embeddings[i2][0];
        }
        return feature;
    }
}

