/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.vectorize;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.translator.ImageFeatureExtractor;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import com.redis.om.spring.annotations.Vectorize;
import com.redis.om.spring.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.stereotype.Component;

@Component
public class FeatureExtractor {
    private final RedisOperations<?, ?> redisOperations;
    private final ZooModel<Image, byte[]> imageEmbeddingModel;
    private final ZooModel<Image, float[]> faceEmbeddingModel;
    private final ImageFactory imageFactory;
    private final ApplicationContext applicationContext;
    private ImageFeatureExtractor imageFeatureExtractor;
    public final Pipeline imagePipeline;
    public final HuggingFaceTokenizer sentenceTokenizer;
    private static final Log logger = LogFactory.getLog(FeatureExtractor.class);

    public FeatureExtractor(RedisOperations<?, ?> redisOperations, ApplicationContext applicationContext, ZooModel<Image, byte[]> imageEmbeddingModel, ZooModel<Image, float[]> faceEmbeddingModel, ImageFactory imageFactory, Pipeline imagePipeline, HuggingFaceTokenizer sentenceTokenizer) {
        this.redisOperations = redisOperations;
        this.applicationContext = applicationContext;
        this.imageEmbeddingModel = imageEmbeddingModel;
        this.faceEmbeddingModel = faceEmbeddingModel;
        this.imageFactory = imageFactory;
        this.imagePipeline = imagePipeline;
        this.sentenceTokenizer = sentenceTokenizer;
        this.imageFeatureExtractor = ((ImageFeatureExtractor.Builder)ImageFeatureExtractor.builder().setPipeline(imagePipeline)).build();
    }

    public void processEntity(byte[] redisKey, Object item) {
        boolean isNew = (Boolean)this.redisOperations.execute(connection -> connection.keyCommands().exists(redisKey) == false);
        this.processEntity(redisKey, item, isNew);
    }

    public byte[] getImageEmbeddingsFor(InputStream is) {
        try {
            Image img = this.imageFactory.fromInputStream(is);
            Predictor predictor = this.imageEmbeddingModel.newPredictor((Translator)this.imageFeatureExtractor);
            return (byte[])predictor.predict((Object)img);
        }
        catch (TranslateException | IOException e) {
            logger.warn((Object)"Error generating image embedding", e);
            return new byte[0];
        }
    }

    public byte[] getFacialImageEmbeddingsFor(InputStream is) throws IOException, TranslateException {
        try (Predictor predictor = this.faceEmbeddingModel.newPredictor();){
            Image img = this.imageFactory.fromInputStream(is);
            byte[] byArray = ObjectUtils.floatArrayToByteArray((float[])predictor.predict((Object)img));
            return byArray;
        }
    }

    public byte[] getSentenceEmbeddingsFor(String text) {
        Encoding encoding = this.sentenceTokenizer.encode(text);
        return ObjectUtils.longArrayToByteArray(encoding.getIds());
    }

    public void processEntity(byte[] redisKey, Object item, boolean isNew) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), Vectorize.class);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> this.lambda$processEntity$1((PropertyAccessor)accessor, arg_0));
        }
    }

    private /* synthetic */ void lambda$processEntity$1(PropertyAccessor accessor, Field f) {
        Vectorize vectorize = f.getAnnotation(Vectorize.class);
        Object fieldValue = accessor.getPropertyValue(f.getName());
        if (fieldValue != null) {
            switch (vectorize.embeddingType()) {
                case IMAGE: {
                    Resource resource = this.applicationContext.getResource(fieldValue.toString());
                    try {
                        byte[] feature = this.getImageEmbeddingsFor(resource.getInputStream());
                        accessor.setPropertyValue(vectorize.destination(), (Object)feature);
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Error generating image embedding", (Throwable)e);
                    }
                    break;
                }
                case FACE: {
                    Resource resource = this.applicationContext.getResource(fieldValue.toString());
                    try {
                        byte[] feature = this.getFacialImageEmbeddingsFor(resource.getInputStream());
                        accessor.setPropertyValue(vectorize.destination(), (Object)feature);
                    }
                    catch (TranslateException | IOException e) {
                        logger.warn((Object)"Error generating facial image embedding", e);
                    }
                    break;
                }
                case SENTENCE: {
                    accessor.setPropertyValue(vectorize.destination(), (Object)this.getSentenceEmbeddingsFor(fieldValue.toString()));
                }
            }
        }
    }
}

