/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class InPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final List<T> values;

    public InPredicate(SearchFieldAccessor field, List<T> values) {
        super(field);
        this.values = values;
    }

    public List<T> getValues() {
        return this.values;
    }

    @Override
    public Node apply(Node root) {
        QueryNode or = QueryBuilders.union((Node[])new Node[0]);
        Class<?> cls = this.values.get(0).getClass();
        for (T value : this.getValues()) {
            long unixTime;
            if (cls == Integer.class) {
                or.add(this.getSearchAlias(), new Value[]{Values.eq((int)Integer.parseInt(value.toString()))});
                continue;
            }
            if (cls == LocalDate.class) {
                LocalDate localDate = (LocalDate)value;
                Instant instant = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
                unixTime = instant.getEpochSecond();
                or.add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime)});
                continue;
            }
            if (cls == Date.class) {
                Date date = (Date)value;
                Instant instant = date.toInstant();
                unixTime = instant.getEpochSecond();
                or.add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime)});
                continue;
            }
            if (cls == LocalDateTime.class) {
                LocalDateTime localDateTime = (LocalDateTime)value;
                Instant instant = localDateTime.toInstant(ZoneOffset.of(ZoneId.systemDefault().getId()));
                unixTime = instant.getEpochSecond();
                or.add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime)});
                continue;
            }
            if (cls == Instant.class) {
                Instant instant = (Instant)value;
                long unixTime2 = instant.getEpochSecond();
                or.add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime2)});
                continue;
            }
            or.add(this.getSearchAlias(), new Value[]{Values.eq((double)Double.parseDouble(value.toString()))});
        }
        return QueryBuilders.intersect((Node[])new Node[]{root, or});
    }
}

