/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.redis.om.spring.annotations.ReducerFunction;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.search.stream.AggregationStream;
import com.redis.om.spring.tuple.Tuple;
import com.redis.om.spring.tuple.Tuples;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.springframework.data.domain.Sort;
import redis.clients.jedis.search.aggr.AggregationBuilder;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.search.aggr.Group;
import redis.clients.jedis.search.aggr.Reducer;
import redis.clients.jedis.search.aggr.Reducers;
import redis.clients.jedis.search.aggr.SortedField;

public class AggregationStreamImpl<E, T>
implements AggregationStream<T> {
    private final AggregationBuilder aggregation;
    private Group currentGroup;
    private ReducerFieldPair currentReducer;
    private final SearchOperations<String> search;
    private final Set<String> returnFields = new LinkedHashSet<String>();
    private final Map<String, Class<?>> returnFieldsTypeHints = new HashMap();
    private static final Integer MAX_LIMIT = 10000;
    private boolean limitSet = false;

    @SafeVarargs
    public AggregationStreamImpl(String searchIndex, RedisModulesOperations<String> modulesOperations, String query, MetamodelField<E, ?> ... fields) {
        this.search = modulesOperations.opsForSearch(searchIndex);
        this.aggregation = new AggregationBuilder(query);
        this.createAggregationGroup(fields);
    }

    @Override
    public AggregationStream<T> load(MetamodelField<?, ?> ... fields) {
        this.applyCurrentGroupBy();
        if (fields.length > 0) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (MetamodelField<?, ?> mmf : fields) {
                aliases.add(mmf.getSearchAlias());
                this.returnFieldsTypeHints.put(mmf.getSearchAlias(), mmf.getTargetClass());
            }
            this.aggregation.load((String[])aliases.stream().map(alias -> String.format("@%s", alias)).toArray(String[]::new));
            this.returnFields.addAll(aliases);
        }
        return this;
    }

    @Override
    public AggregationStream<T> groupBy(MetamodelField<?, ?> ... fields) {
        this.applyCurrentGroupBy();
        this.createAggregationGroup(true, fields);
        return this;
    }

    @Override
    public AggregationStream<T> reduce(ReducerFunction reducer, MetamodelField<?, ?> field, Object ... params) {
        String alias = null;
        if (field != null) {
            alias = field.getSearchAlias();
            this.returnFields.remove(alias.startsWith("@") ? alias.substring(1) : alias);
        }
        if (this.currentGroup == null) {
            this.createAggregationGroup(true, new MetamodelField[0]);
        }
        this.applyCurrentReducer();
        Reducer r = null;
        switch (reducer) {
            case COUNT: {
                r = Reducers.count();
                break;
            }
            case COUNT_DISTINCT: {
                r = Reducers.count_distinct((String)alias);
                break;
            }
            case COUNT_DISTINCTISH: {
                r = Reducers.count_distinctish((String)alias);
                break;
            }
            case SUM: {
                r = Reducers.sum((String)alias);
                break;
            }
            case MIN: {
                r = Reducers.min((String)alias);
                break;
            }
            case MAX: {
                r = Reducers.max((String)alias);
                break;
            }
            case AVG: {
                r = Reducers.avg((String)alias);
                break;
            }
            case STDDEV: {
                r = Reducers.stddev((String)alias);
                break;
            }
            case QUANTILE: {
                double percentile = Double.parseDouble(params[0].toString());
                r = Reducers.quantile((String)alias, (double)percentile);
                break;
            }
            case TOLIST: {
                r = Reducers.to_list((String)alias);
                break;
            }
            case FIRST_VALUE: {
                if (params.length > 0 && params[0].getClass().isAssignableFrom(Sort.Order.class)) {
                    Sort.Order o = (Sort.Order)params[0];
                    SortedField sf = new SortedField(o.getProperty(), o.getDirection() == Sort.Direction.ASC ? SortedField.SortOrder.ASC : SortedField.SortOrder.DESC);
                    r = Reducers.first_value((String)alias, (SortedField)sf);
                    break;
                }
                r = Reducers.first_value((String)alias);
                break;
            }
            case RANDOM_SAMPLE: {
                int sampleSize = Integer.parseInt(params[0].toString());
                r = Reducers.random_sample((String)alias, (int)sampleSize);
            }
        }
        if (r != null) {
            this.currentReducer = ReducerFieldPair.of(r, field);
        }
        return this;
    }

    @Override
    public AggregationStream<T> reduce(ReducerFunction reducer) {
        return this.reduce(reducer, (MetamodelField)null, new Object[0]);
    }

    @Override
    public AggregationStream<T> reduce(ReducerFunction reducer, String alias, Object ... params) {
        return this.reduce(reducer, new MetamodelField(alias, String.class, true), params);
    }

    private boolean applyCurrentReducer() {
        if (this.currentReducer != null) {
            Reducer cr = this.currentReducer.getReducer();
            MetamodelField<?, ?> crField = this.currentReducer.getField();
            if (cr.getAlias() == null) {
                cr.setAlias(cr.getName().toLowerCase());
            }
            this.currentGroup.reduce(cr);
            this.returnFields.add(cr.getAlias());
            this.returnFieldsTypeHints.put(cr.getAlias(), this.getTypeHintForReducer(cr, crField));
            this.currentReducer = null;
            return true;
        }
        return false;
    }

    @Override
    public AggregationStream<T> apply(String expression, String alias) {
        this.applyCurrentGroupBy();
        this.aggregation.apply(expression, alias);
        this.returnFields.add(alias);
        return this;
    }

    @Override
    public AggregationStream<T> as(String alias) {
        if (this.currentReducer != null) {
            this.currentReducer.getReducer().setAlias(alias);
        }
        return this;
    }

    @Override
    public AggregationStream<T> sorted(Sort.Order ... fields) {
        this.applyCurrentGroupBy();
        this.aggregation.sortBy(this.mapToSortedFields(fields));
        this.returnFields.addAll(this.extractAliases(fields));
        return this;
    }

    @Override
    public AggregationStream<T> sorted(int max, Sort.Order ... fields) {
        this.applyCurrentGroupBy();
        this.aggregation.sortBy(max, this.mapToSortedFields(fields));
        this.returnFields.addAll(this.extractAliases(fields));
        return this;
    }

    private List<String> extractAliases(Sort.Order[] fields) {
        return Arrays.stream(fields).map(f -> f.getProperty().startsWith("@") ? f.getProperty().substring(1) : f.getProperty()).toList();
    }

    private SortedField[] mapToSortedFields(Sort.Order ... fields) {
        return (SortedField[])Arrays.stream(fields).map(f -> f.isDescending() ? SortedField.desc((String)f.getProperty()) : SortedField.asc((String)f.getProperty())).toList().toArray(SortedField[]::new);
    }

    @Override
    public AggregationStream<T> limit(int limit) {
        this.applyCurrentGroupBy();
        this.aggregation.limit(limit);
        this.limitSet = true;
        return this;
    }

    @Override
    public AggregationStream<T> limit(int offset, int limit) {
        this.applyCurrentGroupBy();
        this.aggregation.limit(offset, limit);
        this.limitSet = true;
        return this;
    }

    @Override
    public AggregationStream<T> filter(String ... filters) {
        this.applyCurrentGroupBy();
        for (String filter : filters) {
            this.aggregation.filter(filter);
        }
        return this;
    }

    @Override
    public AggregationResult aggregate() {
        this.applyCurrentGroupBy();
        return this.search.aggregate(this.aggregation);
    }

    @Override
    public AggregationResult aggregateVerbatim() {
        this.aggregation.verbatim();
        return this.search.aggregate(this.aggregation);
    }

    @Override
    public AggregationResult aggregate(Duration timeout) {
        if (!this.limitSet) {
            this.aggregation.limit(MAX_LIMIT.intValue());
        }
        this.aggregation.timeout(timeout.toMillis());
        return this.search.aggregate(this.aggregation);
    }

    @Override
    public AggregationResult aggregateVerbatim(Duration timeout) {
        if (!this.limitSet) {
            this.aggregation.limit(MAX_LIMIT.intValue());
        }
        this.aggregation.timeout(timeout.toMillis());
        this.aggregation.verbatim();
        return this.search.aggregate(this.aggregation);
    }

    @Override
    public <R extends T> List<R> toList(Class<?> ... contentTypes) {
        this.applyCurrentGroupBy();
        if (!this.limitSet) {
            this.aggregation.limit(MAX_LIMIT.intValue());
        }
        AggregationResult aggregationResult = this.search.aggregate(this.aggregation);
        String[] labels = (String[])this.returnFields.toArray(String[]::new);
        List<Tuple> asList = aggregationResult.getResults().stream().map(m -> {
            ArrayList<Object> mappedValues = new ArrayList<Object>();
            for (int i = 0; i < labels.length; ++i) {
                Object raw = m.get(labels[i]);
                if (contentTypes[i] == String.class) {
                    mappedValues.add(raw != null ? new String((byte[])raw) : "");
                    continue;
                }
                if (contentTypes[i] == Long.class) {
                    mappedValues.add(raw != null ? Long.parseLong(new String((byte[])raw)) : 0L);
                    continue;
                }
                if (contentTypes[i] == Integer.class) {
                    mappedValues.add(raw != null ? Integer.parseInt(new String((byte[])raw)) : 0);
                    continue;
                }
                if (contentTypes[i] == Double.class) {
                    mappedValues.add(raw != null ? Double.parseDouble(new String((byte[])raw)) : 0.0);
                    continue;
                }
                if (contentTypes[i] != List.class || !List.class.isAssignableFrom(raw.getClass())) continue;
                Class<?> listContents = this.returnFieldsTypeHints.get(labels[i]);
                List rawList = (List)raw;
                if (listContents != null) {
                    if (listContents == String.class) {
                        mappedValues.add(rawList.stream().map(e -> e != null ? new String((byte[])e) : "").toList());
                        continue;
                    }
                    if (listContents == Long.class) {
                        mappedValues.add(rawList.stream().map(e -> e != null ? Long.parseLong(new String((byte[])e)) : 0L).toList());
                        continue;
                    }
                    if (listContents == Integer.class) {
                        mappedValues.add(rawList.stream().map(e -> e != null ? Integer.parseInt(new String((byte[])e)) : 0).toList());
                        continue;
                    }
                    if (listContents == Double.class) {
                        mappedValues.add(rawList.stream().map(e -> e != null ? Double.parseDouble(new String((byte[])e)) : 0.0).toList());
                        continue;
                    }
                    mappedValues.add(rawList);
                    continue;
                }
                mappedValues.add(rawList);
            }
            Object[] values = mappedValues.toArray();
            return switch (labels.length) {
                case 1 -> Tuples.of(labels, values[0]);
                case 2 -> Tuples.of(labels, values[0], values[1]);
                case 3 -> Tuples.of(labels, values[0], values[1], values[2]);
                case 4 -> Tuples.of(labels, values[0], values[1], values[2], values[3]);
                case 5 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4]);
                case 6 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5]);
                case 7 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
                case 8 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
                case 9 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8]);
                case 10 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9]);
                case 11 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10]);
                case 12 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11]);
                case 13 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12]);
                case 14 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13]);
                case 15 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14]);
                case 16 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]);
                case 17 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16]);
                case 18 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17]);
                case 19 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18]);
                case 20 -> Tuples.of(labels, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19]);
                default -> Tuples.of();
            };
        }).toList();
        return asList;
    }

    private void applyCurrentGroupBy() {
        if (this.currentGroup != null) {
            if (this.applyCurrentReducer()) {
                this.aggregation.groupBy(this.currentGroup);
            }
            this.currentGroup = null;
        }
    }

    private void createAggregationGroup(MetamodelField<?, ?> ... fields) {
        this.createAggregationGroup(false, fields);
    }

    private void createAggregationGroup(boolean createIfEmpty, MetamodelField<?, ?> ... fields) {
        if (fields.length > 0) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (MetamodelField<?, ?> mmf : fields) {
                aliases.add(mmf.getSearchAlias());
                this.returnFieldsTypeHints.put(mmf.getSearchAlias(), mmf.getTargetClass());
            }
            this.currentGroup = new Group((String[])aliases.stream().map(alias -> String.format("@%s", alias)).toArray(String[]::new));
            this.returnFields.addAll(aliases);
        } else if (createIfEmpty) {
            this.currentGroup = new Group(new String[0]);
        }
    }

    private Class<?> getTypeHintForReducer(Reducer cr, MetamodelField<?, ?> field) {
        Class<?> fieldTargetClass = field != null ? field.getTargetClass() : null;
        return switch (cr.getName()) {
            case "COUNT", "COUNT_DISTINCT", "COUNT_DISTINCTISH" -> Long.class;
            case "SUM", "MIN", "MAX", "QUANTILE", "FIRST_VALUE", "TOLIST", "RANDOM_SAMPLE" -> {
                if (fieldTargetClass != null) {
                    yield fieldTargetClass;
                }
                yield String.class;
            }
            case "AVG", "STDDEV" -> Double.class;
            default -> String.class;
        };
    }

    private static class ReducerFieldPair {
        @NonNull
        private Reducer reducer;
        private MetamodelField<?, ?> field;

        @NonNull
        public Reducer getReducer() {
            return this.reducer;
        }

        public MetamodelField<?, ?> getField() {
            return this.field;
        }

        public void setReducer(@NonNull Reducer reducer) {
            if (reducer == null) {
                throw new NullPointerException("reducer is marked non-null but is null");
            }
            this.reducer = reducer;
        }

        public void setField(MetamodelField<?, ?> field) {
            this.field = field;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReducerFieldPair)) {
                return false;
            }
            ReducerFieldPair other = (ReducerFieldPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Reducer this$reducer = this.getReducer();
            Reducer other$reducer = other.getReducer();
            if (this$reducer == null ? other$reducer != null : !this$reducer.equals(other$reducer)) {
                return false;
            }
            MetamodelField<?, ?> this$field = this.getField();
            MetamodelField<?, ?> other$field = other.getField();
            return !(this$field == null ? other$field != null : !this$field.equals(other$field));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReducerFieldPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Reducer $reducer = this.getReducer();
            result = result * 59 + ($reducer == null ? 43 : $reducer.hashCode());
            MetamodelField<?, ?> $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            return result;
        }

        public String toString() {
            return "AggregationStreamImpl.ReducerFieldPair(reducer=" + this.getReducer() + ", field=" + this.getField() + ")";
        }

        private ReducerFieldPair(@NonNull Reducer reducer, MetamodelField<?, ?> field) {
            if (reducer == null) {
                throw new NullPointerException("reducer is marked non-null but is null");
            }
            this.reducer = reducer;
            this.field = field;
        }

        public static ReducerFieldPair of(@NonNull Reducer reducer, MetamodelField<?, ?> field) {
            return new ReducerFieldPair(reducer, field);
        }
    }
}

