/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.client;

import com.google.gson.GsonBuilder;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.bloom.commands.BloomFilterCommands;
import redis.clients.jedis.bloom.commands.CountMinSketchCommands;
import redis.clients.jedis.bloom.commands.CuckooFilterCommands;
import redis.clients.jedis.bloom.commands.TopKFilterCommands;
import redis.clients.jedis.json.RedisJsonCommands;
import redis.clients.jedis.search.RediSearchCommands;

public class RedisModulesClient {
    private final GsonBuilder builder;
    private final UnifiedJedis unifiedJedis;
    private final JedisConnectionFactory jedisConnectionFactory;

    public RedisModulesClient(JedisConnectionFactory jedisConnectionFactory, GsonBuilder builder) {
        this.jedisConnectionFactory = jedisConnectionFactory;
        this.builder = builder;
        this.unifiedJedis = this.getUnifiedJedis();
    }

    public RedisJsonCommands clientForJSON() {
        return this.unifiedJedis;
    }

    public RediSearchCommands clientForSearch() {
        return this.unifiedJedis;
    }

    public BloomFilterCommands clientForBloom() {
        return this.unifiedJedis;
    }

    public CountMinSketchCommands clientForCMS() {
        return this.unifiedJedis;
    }

    public CuckooFilterCommands clientForCuckoo() {
        return this.unifiedJedis;
    }

    public TopKFilterCommands clientForTopK() {
        return this.unifiedJedis;
    }

    private UnifiedJedis getUnifiedJedis() {
        JedisClientConfiguration cc = this.jedisConnectionFactory.getClientConfiguration();
        HostAndPort hostAndPort = new HostAndPort(this.jedisConnectionFactory.getHostName(), this.jedisConnectionFactory.getPort());
        JedisClientConfig jedisClientConfig = this.createClientConfig(this.jedisConnectionFactory.getDatabase(), this.jedisConnectionFactory.getStandaloneConfiguration().getUsername(), this.jedisConnectionFactory.getStandaloneConfiguration().getPassword(), cc);
        return new JedisPooled(Objects.requireNonNull(this.jedisConnectionFactory.getPoolConfig()), hostAndPort, jedisClientConfig);
    }

    public Optional<Jedis> getJedis() {
        Object nativeConnection = this.jedisConnectionFactory.getConnection().getNativeConnection();
        if (nativeConnection instanceof Jedis) {
            Jedis jedis = (Jedis)nativeConnection;
            return Optional.of(jedis);
        }
        return Optional.empty();
    }

    public Optional<JedisCluster> getJedisCluster() {
        Object nativeConnection = this.jedisConnectionFactory.getConnection().getNativeConnection();
        if (nativeConnection instanceof JedisCluster) {
            JedisCluster jedisCluster = (JedisCluster)nativeConnection;
            return Optional.of(jedisCluster);
        }
        return Optional.empty();
    }

    public GsonBuilder gsonBuilder() {
        return this.builder;
    }

    private JedisClientConfig createClientConfig(int database, @Nullable String username, RedisPassword password, JedisClientConfiguration clientConfiguration) {
        DefaultJedisClientConfig.Builder builder = DefaultJedisClientConfig.builder();
        clientConfiguration.getClientName().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).clientName(arg_0));
        builder.connectionTimeoutMillis(Math.toIntExact(clientConfiguration.getConnectTimeout().toMillis()));
        builder.socketTimeoutMillis(Math.toIntExact(clientConfiguration.getReadTimeout().toMillis()));
        builder.database(database);
        if (!ObjectUtils.isEmpty((Object)username)) {
            builder.user(username);
        }
        password.toOptional().map(String::new).ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).password(arg_0));
        if (clientConfiguration.isUseSsl()) {
            builder.ssl(true);
            clientConfiguration.getSslSocketFactory().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).sslSocketFactory(arg_0));
            clientConfiguration.getHostnameVerifier().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).hostnameVerifier(arg_0));
            clientConfiguration.getSslParameters().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).sslParameters(arg_0));
        }
        return builder.build();
    }
}

