/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.google.gson.annotations.JsonAdapter;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.DocumentScore;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.SchemaFieldType;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.annotations.VectorIndexed;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.IndexDefinition;
import redis.clients.jedis.search.IndexOptions;
import redis.clients.jedis.search.Schema;

@Component
public class RediSearchIndexer {
    private final Map<String, Class<?>> keyspaceToEntityClass = new ConcurrentHashMap();
    private final Map<Class<?>, String> entityClassToKeySpace = new ConcurrentHashMap();
    private final List<Class<?>> indexedEntityClasses = new ArrayList();
    private final Map<Class<?>, Schema> entityClassToSchema = new ConcurrentHashMap();
    private static final Log logger = LogFactory.getLog(RediSearchIndexer.class);
    private final ApplicationContext ac;
    private final RedisModulesOperations<String> rmo;
    private final RedisMappingContext mappingContext;
    private static final String SKIPPING_INDEX_CREATION = "Skipping index creation for %s because %s";

    public RediSearchIndexer(ApplicationContext ac) {
        this.ac = ac;
        this.rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        this.mappingContext = (RedisMappingContext)ac.getBean("keyValueMappingContext");
    }

    public void createIndicesFor(Class<?> cls) {
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>(ObjectUtils.getBeanDefinitionsFor(this.ac, cls));
        logger.info((Object)String.format("Found %s @%s annotated Beans...", beanDefs.size(), cls.getSimpleName()));
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                this.createIndexFor(cl);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, beanDef.getBeanClassName(), e.getMessage()));
            }
        }
    }

    public void createIndexFor(Class<?> cl) {
        IndexDefinition.Type idxType;
        if (cl.isAnnotationPresent(Document.class)) {
            idxType = IndexDefinition.Type.JSON;
        } else if (cl.isAnnotationPresent(RedisHash.class)) {
            idxType = IndexDefinition.Type.HASH;
        } else {
            return;
        }
        Object indexName = "";
        String scoreField = null;
        try {
            RedisHash hash;
            Field idField;
            indexName = cl.getName() + "Idx";
            logger.info((Object)String.format("Found @%s annotated class: %s", idxType, cl.getName()));
            List<Field> allClassFields = ObjectUtils.getDeclaredFieldsTransitively(cl);
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            for (Field field : allClassFields) {
                fields.addAll(this.findIndexFields(field, null, idxType == IndexDefinition.Type.JSON));
                if (!field.isAnnotationPresent(DocumentScore.class)) continue;
                String fieldPrefix = idxType == IndexDefinition.Type.JSON ? "$." : "";
                scoreField = fieldPrefix + field.getName();
            }
            Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(cl);
            if (maybeIdField.isPresent() && !(idField = maybeIdField.get()).isAnnotationPresent(Indexed.class) && !idField.isAnnotationPresent(Searchable.class) && fields.stream().noneMatch(f -> f.name.equals(idField.getName()))) {
                if (Number.class.isAssignableFrom(idField.getType())) {
                    fields.add(this.indexAsNumericFieldFor(maybeIdField.get(), idxType == IndexDefinition.Type.JSON, "", true, false));
                } else {
                    fields.add(this.indexAsTagFieldFor(maybeIdField.get(), idxType == IndexDefinition.Type.JSON, "", false, "|", Integer.MIN_VALUE));
                }
            }
            String entityPrefix = this.getEntityPrefix(cl);
            Schema schema = new Schema();
            SearchOperations<String> opsForSearch = this.rmo.opsForSearch((String)indexName);
            for (Schema.Field field : fields) {
                schema.addField(field);
            }
            IndexDefinition index = new IndexDefinition(idxType);
            if (cl.isAnnotationPresent(Document.class)) {
                Document document = cl.getAnnotation(Document.class);
                index.setAsync(document.async());
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.value())) {
                    entityPrefix = document.value();
                }
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.filter())) {
                    index.setFilter(document.filter());
                }
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)((Object)document.language()))) {
                    index.setLanguage(document.language().getValue());
                }
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.languageField())) {
                    index.setLanguageField(document.languageField());
                }
                index.setScore(document.score());
                if (scoreField != null) {
                    index.setScoreFiled(scoreField);
                }
            } else if (cl.isAnnotationPresent(RedisHash.class) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(hash = cl.getAnnotation(RedisHash.class)).value())) {
                entityPrefix = hash.value();
            }
            index.setPrefixes(new String[]{entityPrefix});
            IndexOptions ops = IndexOptions.defaultOptions().setDefinition(index);
            this.addKeySpaceMapping(entityPrefix, cl);
            if (cl.isAnnotationPresent(Document.class)) {
                KeyspaceConfiguration.KeyspaceSettings setting = new KeyspaceConfiguration.KeyspaceSettings(cl, entityPrefix);
                Document document = cl.getAnnotation(Document.class);
                if (document.timeToLive() > 0L) {
                    setting.setTimeToLive(Long.valueOf(document.timeToLive()));
                }
                for (Field field : allClassFields) {
                    if (!field.isAnnotationPresent(TimeToLive.class)) continue;
                    setting.setTimeToLivePropertyName(field.getName());
                }
                this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration().addKeyspaceSettings(setting);
            }
            opsForSearch.createIndex(schema, ops);
            this.entityClassToSchema.put(cl, schema);
        }
        catch (Exception e) {
            logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, indexName, e.getMessage()));
        }
    }

    public void dropIndexAndDocumentsFor(Class<?> cl) {
        Object indexName = "";
        try {
            RedisHash hash;
            indexName = cl.getName() + "Idx";
            logger.info((Object)String.format("Dropping index @%s for class: %s", indexName, cl.getName()));
            SearchOperations<String> opsForSearch = this.rmo.opsForSearch((String)indexName);
            opsForSearch.dropIndexAndDocuments();
            String entityPrefix = this.getEntityPrefix(cl);
            if (cl.isAnnotationPresent(Document.class)) {
                Document document = cl.getAnnotation(Document.class);
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.value())) {
                    entityPrefix = document.value();
                }
            } else if (cl.isAnnotationPresent(RedisHash.class) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(hash = cl.getAnnotation(RedisHash.class)).value())) {
                entityPrefix = hash.value();
            }
            this.removeKeySpaceMapping(entityPrefix, cl);
        }
        catch (Exception e) {
            logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, indexName, e.getMessage()));
        }
    }

    private List<Schema.Field> findIndexFields(Field field, String prefix, boolean isDocument) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        if (field.isAnnotationPresent(Indexed.class)) {
            logger.info((Object)String.format("Found @Indexed annotation on field of type: %s", field.getType()));
            Indexed indexed = field.getAnnotation(Indexed.class);
            Class fieldType = ClassUtils.resolvePrimitiveIfNecessary(field.getType());
            if (indexed.schemaFieldType() == SchemaFieldType.AUTODETECT) {
                if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class || fieldType.isEnum()) {
                    fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex()));
                } else if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || field.getType() == LocalDate.class || field.getType() == Date.class || field.getType() == Instant.class) {
                    fields.add(this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex()));
                } else if (Set.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                    Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementType(field);
                    if (maybeCollectionType.isPresent()) {
                        Class<?> collectionType = maybeCollectionType.get();
                        if (CharSequence.class.isAssignableFrom(collectionType) || collectionType == Boolean.class) {
                            fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex()));
                        } else if (isDocument) {
                            if (Number.class.isAssignableFrom(collectionType)) {
                                fields.add(this.indexAsNumericFieldFor(field, true, prefix, indexed.sortable(), indexed.noindex()));
                            } else if (collectionType == Point.class) {
                                fields.add(this.indexAsGeoFieldFor(field, true, prefix, indexed.sortable(), indexed.noindex()));
                            } else {
                                logger.debug((Object)String.format("Found nested field on field of type: %s", field.getType()));
                                fields.addAll(this.indexAsNestedFieldFor(field, prefix));
                            }
                        }
                    } else {
                        logger.debug((Object)String.format("Could not determine the type of elements in the collection %s in entity %s", field.getName(), field.getDeclaringClass().getSimpleName()));
                    }
                } else if (fieldType == Point.class) {
                    fields.add(this.indexAsGeoFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex()));
                } else {
                    for (Field subfield : ObjectUtils.getDeclaredFieldsTransitively(field.getType())) {
                        String subfieldPrefix = prefix == null || prefix.isBlank() ? field.getName() : String.join((CharSequence)".", prefix, field.getName());
                        fields.addAll(this.findIndexFields(subfield, subfieldPrefix, isDocument));
                    }
                }
            } else {
                switch (indexed.schemaFieldType()) {
                    case TAG: {
                        fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex()));
                        break;
                    }
                    case NUMERIC: {
                        fields.add(this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex()));
                        break;
                    }
                    case GEO: {
                        fields.add(this.indexAsGeoFieldFor(field, true, prefix, indexed.sortable(), indexed.noindex()));
                        break;
                    }
                    case VECTOR: {
                        fields.add(this.indexAsVectorFieldFor(field, isDocument, prefix, indexed));
                        break;
                    }
                    case NESTED: {
                        for (Field subfield : ObjectUtils.getDeclaredFieldsTransitively(field.getType())) {
                            String subfieldPrefix = prefix == null || prefix.isBlank() ? field.getName() : String.join((CharSequence)".", prefix, field.getName());
                            fields.addAll(this.findIndexFields(subfield, subfieldPrefix, isDocument));
                        }
                        break;
                    }
                }
            }
        } else if (field.isAnnotationPresent(Searchable.class)) {
            logger.info((Object)String.format("Found @Searchable annotation on field of type: %s", field.getType()));
            Searchable searchable = field.getAnnotation(Searchable.class);
            fields.add(this.indexAsTextFieldFor(field, isDocument, prefix, searchable));
        } else if (field.isAnnotationPresent(TextIndexed.class)) {
            TextIndexed ti = field.getAnnotation(TextIndexed.class);
            fields.add(this.indexAsTextFieldFor(field, isDocument, prefix, ti));
        } else if (field.isAnnotationPresent(TagIndexed.class)) {
            TagIndexed ti = field.getAnnotation(TagIndexed.class);
            fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, ti));
        } else if (field.isAnnotationPresent(GeoIndexed.class)) {
            GeoIndexed gi = field.getAnnotation(GeoIndexed.class);
            fields.add(this.indexAsGeoFieldFor(field, isDocument, prefix, gi));
        } else if (field.isAnnotationPresent(NumericIndexed.class)) {
            NumericIndexed ni = field.getAnnotation(NumericIndexed.class);
            fields.add(this.indexAsNumericFieldFor(field, isDocument, prefix, ni));
        } else if (field.isAnnotationPresent(VectorIndexed.class)) {
            VectorIndexed vi = field.getAnnotation(VectorIndexed.class);
            fields.add(this.indexAsVectorFieldFor(field, isDocument, prefix, vi));
        }
        return fields;
    }

    private Schema.Field indexAsTagFieldFor(Field field, boolean isDocument, String prefix, TagIndexed ti) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? "[*]" : "";
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName() + fieldPostfix));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? fieldName.as(ti.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.TagField(fieldName, ti.separator(), false);
    }

    private Schema.Field indexAsVectorFieldFor(Field field, boolean isDocument, String prefix, Indexed indexed) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? "[*]" : "";
        String fieldName = fieldPrefix + field.getName() + fieldPostfix;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("TYPE", indexed.type().toString());
        attributes.put("DIM", indexed.dimension());
        attributes.put("DISTANCE_METRIC", (Object)indexed.distanceMetric());
        if (indexed.initialCapacity() > 0) {
            attributes.put("INITIAL_CAP", indexed.initialCapacity());
        }
        if (indexed.algorithm().equals((Object)Schema.VectorField.VectorAlgo.FLAT) && indexed.blockSize() > 0) {
            attributes.put("BLOCK_SIZE", indexed.blockSize());
        }
        if (indexed.algorithm().equals((Object)Schema.VectorField.VectorAlgo.HNSW)) {
            attributes.put("M", indexed.m());
            attributes.put("EF_CONSTRUCTION", indexed.efConstruction());
            if (indexed.efRuntime() != 10) {
                attributes.put("EF_RUNTIME", indexed.efRuntime());
            }
            if (indexed.epsilon() != 0.01) {
                attributes.put("EPSILON", indexed.epsilon());
            }
        }
        Schema.VectorField vectorField = new Schema.VectorField(fieldName, indexed.algorithm(), attributes);
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)indexed.alias())) {
            vectorField.as(indexed.alias());
        } else {
            vectorField.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        }
        return vectorField;
    }

    private Schema.Field indexAsVectorFieldFor(Field field, boolean isDocument, String prefix, VectorIndexed vi) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? "[*]" : "";
        String fieldName = fieldPrefix + field.getName() + fieldPostfix;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("TYPE", vi.type().toString());
        attributes.put("DIM", vi.dimension());
        attributes.put("DISTANCE_METRIC", (Object)vi.distanceMetric());
        if (vi.initialCapacity() > 0) {
            attributes.put("INITIAL_CAP", vi.initialCapacity());
        }
        if (vi.algorithm().equals((Object)Schema.VectorField.VectorAlgo.FLAT) && vi.blockSize() > 0) {
            attributes.put("BLOCK_SIZE", vi.blockSize());
        }
        if (vi.algorithm().equals((Object)Schema.VectorField.VectorAlgo.HNSW)) {
            attributes.put("M", vi.m());
            attributes.put("EF_CONSTRUCTION", vi.efConstruction());
            if (vi.efRuntime() != 10) {
                attributes.put("EF_RUNTIME", vi.efRuntime());
            }
            if (vi.epsilon() != 0.01) {
                attributes.put("EPSILON", vi.epsilon());
            }
        }
        Schema.VectorField vectorField = new Schema.VectorField(fieldName, vi.algorithm(), attributes);
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)vi.alias())) {
            vectorField.as(vi.alias());
        } else {
            vectorField.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        }
        return vectorField;
    }

    private Schema.Field indexAsTagFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, String separator, int arrayIndex) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        Object index = arrayIndex != Integer.MIN_VALUE ? ".[" + arrayIndex + "]" : "[*]";
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? index : "";
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName() + fieldPostfix));
        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.TagField(fieldName, separator.isBlank() ? null : separator, sortable);
    }

    private Schema.Field indexAsTextFieldFor(Field field, boolean isDocument, String prefix, TextIndexed ti) {
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? fieldName.as(ti.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return new Schema.TextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic);
    }

    private Schema.Field indexAsTextFieldFor(Field field, boolean isDocument, String prefix, Searchable ti) {
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? fieldName.as(ti.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return new Schema.TextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic);
    }

    private Schema.Field indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, GeoIndexed gi) {
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)gi.alias()) ? fieldName.as(gi.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.GEO);
    }

    private Schema.Field indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, NumericIndexed ni) {
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ni.alias()) ? fieldName.as(ni.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.NUMERIC);
    }

    private Schema.Field indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, boolean noIndex) {
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName()));
        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.NUMERIC, sortable, noIndex);
    }

    private Schema.Field indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, boolean noIndex) {
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + field.getName()));
        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.GEO);
    }

    private List<Schema.Field> indexAsNestedFieldFor(Field field, String prefix) {
        String fieldPrefix = this.getFieldPrefix(prefix, true);
        return this.getNestedField(fieldPrefix, field, prefix, null);
    }

    private List<Schema.Field> getNestedField(String fieldPrefix, Field field, String prefix, List<Schema.Field> fieldList) {
        Type genericType;
        if (fieldList == null) {
            fieldList = new ArrayList<Schema.Field>();
        }
        if ((genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
            List<Field> subDeclaredFields = ObjectUtils.getDeclaredFieldsTransitively(actualTypeArgument);
            Object tempPrefix = "";
            prefix = prefix == null ? field.getName() : (String)prefix + "." + field.getName();
            for (Field subField : subDeclaredFields) {
                FieldName fieldName;
                Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementType(subField);
                if (subField.isAnnotationPresent(TagIndexed.class)) {
                    TagIndexed ti = subField.getAnnotation(TagIndexed.class);
                    tempPrefix = field.getName() + "[0:].";
                    fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName()));
                    fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                    logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                    fieldList.add((Schema.Field)new Schema.TagField(fieldName, ti.separator(), false));
                    continue;
                }
                if (subField.isAnnotationPresent(Indexed.class)) {
                    boolean subFieldIsTagField;
                    boolean bl = subFieldIsTagField = subField.isAnnotationPresent(Indexed.class) && (CharSequence.class.isAssignableFrom(subField.getType()) || subField.getType() == Boolean.class || maybeCollectionType.isPresent() && (CharSequence.class.isAssignableFrom(maybeCollectionType.get()) || maybeCollectionType.get() == Boolean.class));
                    if (subFieldIsTagField) {
                        Indexed indexed = subField.getAnnotation(Indexed.class);
                        tempPrefix = field.getName() + "[0:].";
                        FieldName fieldName2 = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName()));
                        fieldName2 = fieldName2.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                        logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                        fieldList.add((Schema.Field)new Schema.TagField(fieldName2, indexed.separator(), false));
                        continue;
                    }
                    if (Number.class.isAssignableFrom(subField.getType()) || subField.getType() == LocalDateTime.class || subField.getType() == LocalDate.class || subField.getType() == Date.class) {
                        fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName()));
                        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                        logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                        fieldList.add(new Schema.Field(fieldName, Schema.FieldType.NUMERIC));
                    }
                } else if (subField.isAnnotationPresent(Searchable.class)) {
                    Searchable searchable = subField.getAnnotation(Searchable.class);
                    tempPrefix = field.getName() + "[0:].";
                    fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName()));
                    fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                    logger.info((Object)String.format("Creating TEXT nested relationships: %s -> %s", field.getName(), subField.getName()));
                    String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)searchable.phonetic()) ? null : searchable.phonetic();
                    fieldList.add((Schema.Field)new Schema.TextField(fieldName, searchable.weight(), searchable.sortable(), searchable.nostem(), searchable.noindex(), phonetic));
                    continue;
                }
                this.getNestedField(fieldPrefix + (String)tempPrefix, subField, (String)prefix, fieldList);
            }
        }
        return fieldList;
    }

    private String getEntityPrefix(Class<?> cl) {
        String entityPrefix = cl.getName() + ":";
        if (this.mappingContext.hasPersistentEntityFor(cl)) {
            RedisPersistentEntity persistentEntity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(cl);
            entityPrefix = persistentEntity.getKeySpace() != null ? persistentEntity.getKeySpace() + ":" : entityPrefix;
            logger.info((Object)String.format("Using entity prefix '%s' as keyspace for type : %s", entityPrefix, cl));
        }
        return entityPrefix;
    }

    public Optional<String> getIndexName(String keyspace) {
        Class<?> entityClass = this.keyspaceToEntityClass.get(this.getKey(keyspace));
        if (entityClass != null) {
            return Optional.of(entityClass.getName() + "Idx");
        }
        return Optional.empty();
    }

    public Optional<String> getIndexName(Class<?> entityClass) {
        if (this.entityClassToKeySpace.containsKey(entityClass)) {
            return Optional.of(entityClass.getName() + "Idx");
        }
        return Optional.empty();
    }

    public void addKeySpaceMapping(String keyspace, Class<?> entityClass) {
        String key = this.getKey(keyspace);
        this.keyspaceToEntityClass.put(key, entityClass);
        this.entityClassToKeySpace.put(entityClass, key);
        this.indexedEntityClasses.add(entityClass);
    }

    public void removeKeySpaceMapping(String keyspace, Class<?> entityClass) {
        String key = this.getKey(keyspace);
        this.keyspaceToEntityClass.remove(key);
        this.entityClassToKeySpace.remove(entityClass);
        this.indexedEntityClasses.remove(entityClass);
    }

    public Class<?> getEntityClassForKeyspace(String keyspace) {
        return this.keyspaceToEntityClass.get(this.getKey(keyspace));
    }

    public String getKeyspaceForEntityClass(Class<?> entityClass) {
        Object keyspace = this.entityClassToKeySpace.get(entityClass);
        if (keyspace == null) {
            keyspace = ((RedisPersistentEntity)this.mappingContext.getPersistentEntity(entityClass)).getKeySpace() + ":";
        }
        return keyspace;
    }

    public boolean indexExistsFor(Class<?> entityClass) {
        return this.indexedEntityClasses.contains(entityClass);
    }

    private String getKey(String keyspace) {
        return keyspace.endsWith(":") ? keyspace : keyspace + ":";
    }

    private String getFieldPrefix(String prefix, boolean isDocument) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        return isDocument ? "$." + chain : chain;
    }
}

