/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search.querybuilder;

import com.redis.lettucemod.search.querybuilder.Node;
import com.redis.lettucemod.search.querybuilder.Value;
import com.redis.lettucemod.search.querybuilder.Values;
import java.util.StringJoiner;

public class ValueNode
implements Node {
    private final Value[] values;
    private final String field;
    private final String joinString;

    public ValueNode(String field, String joinstr, Value ... values) {
        this.field = field;
        this.values = values;
        this.joinString = joinstr;
    }

    private static Value[] fromStrings(String[] values) {
        Value[] objs = new Value[values.length];
        for (int i = 0; i < values.length; ++i) {
            objs[i] = Values.value(values[i]);
        }
        return objs;
    }

    public ValueNode(String field, String joinstr, String ... values) {
        this(field, joinstr, ValueNode.fromStrings(values));
    }

    private String formatField() {
        if (this.field == null || this.field.isEmpty()) {
            return "";
        }
        return '@' + this.field + ':';
    }

    private String toStringCombinable(Node.ParenMode mode) {
        StringBuilder sb = new StringBuilder(this.formatField());
        if (this.values.length > 1 || mode == Node.ParenMode.ALWAYS) {
            sb.append('(');
        }
        StringJoiner sj = new StringJoiner(this.joinString);
        for (Value v : this.values) {
            sj.add(v.toString());
        }
        sb.append(sj.toString());
        if (this.values.length > 1 || mode == Node.ParenMode.ALWAYS) {
            sb.append(')');
        }
        return sb.toString();
    }

    private String toStringDefault(Node.ParenMode mode) {
        boolean useParen;
        boolean bl = useParen = mode == Node.ParenMode.ALWAYS;
        if (!useParen) {
            useParen = mode != Node.ParenMode.NEVER && this.values.length > 1;
        }
        StringBuilder sb = new StringBuilder();
        if (useParen) {
            sb.append('(');
        }
        StringJoiner sj = new StringJoiner(this.joinString);
        for (Value v : this.values) {
            sj.add(this.formatField() + v.toString());
        }
        sb.append(sj.toString());
        if (useParen) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String toString(Node.ParenMode mode) {
        if (this.values[0].isCombinable()) {
            return this.toStringCombinable(mode);
        }
        return this.toStringDefault(mode);
    }
}

