/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.RazorpayException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONObject;

public class Utils {
    public static boolean verifyPaymentSignature(JSONObject attributes, String apiSecret) throws RazorpayException {
        String expectedSignature = attributes.getString("razorpay_signature");
        String orderId = attributes.getString("razorpay_order_id");
        String paymentId = attributes.getString("razorpay_payment_id");
        String payload = orderId + '|' + paymentId;
        return Utils.verifySignature(payload, expectedSignature, apiSecret);
    }

    public static boolean verifyWebhookSignature(String payload, String expectedSignature, String webhookSecret) throws RazorpayException {
        return Utils.verifySignature(payload, expectedSignature, webhookSecret);
    }

    public static boolean verifySignature(String payload, String expectedSignature, String secret) throws RazorpayException {
        String actualSignature = Utils.getHash(payload, secret);
        return Utils.isEqual(actualSignature.getBytes(), expectedSignature.getBytes());
    }

    public static String getHash(String payload, String secret) throws RazorpayException {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] hash = sha256_HMAC.doFinal(payload.getBytes());
            return new String(Hex.encodeHex((byte[])hash));
        }
        catch (Exception e) {
            throw new RazorpayException(e.getMessage());
        }
    }

    private static boolean isEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result |= a[i] ^ b[i];
        }
        return result == 0;
    }
}

