/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiClient;
import com.razorpay.ApiUtils;
import com.razorpay.BankTransfer;
import com.razorpay.Payment;
import com.razorpay.RazorpayException;
import com.razorpay.Refund;
import com.razorpay.RefundClient;
import com.razorpay.Transfer;
import java.util.List;
import okhttp3.Response;
import org.json.JSONObject;

public class PaymentClient
extends ApiClient {
    private RefundClient refundClient;

    PaymentClient(String auth) {
        super(auth);
        this.refundClient = new RefundClient(auth);
    }

    public Payment fetch(String id) throws RazorpayException {
        return (Payment)this.get(String.format("payments/%s", id), null);
    }

    public List<Payment> fetchAll(JSONObject request) throws RazorpayException {
        return this.getCollection("payments", request);
    }

    public List<Payment> fetchAll() throws RazorpayException {
        return this.fetchAll(null);
    }

    public Payment capture(String id, JSONObject request) throws RazorpayException {
        return (Payment)this.post(String.format("payments/%s/capture", id), request);
    }

    public Refund refund(String id) throws RazorpayException {
        return this.refund(id, null);
    }

    public Refund refund(String id, JSONObject request) throws RazorpayException {
        return (Refund)this.post(String.format("payments/%s/refund", id), request);
    }

    public Refund refund(JSONObject request) throws RazorpayException {
        return this.refundClient.create(request);
    }

    public Refund fetchRefund(String id, String refundId) throws RazorpayException {
        return (Refund)this.get(String.format("payments/%s/refunds/%s", id, refundId), null);
    }

    public Refund fetchRefund(String refundId) throws RazorpayException {
        return this.refundClient.fetch(refundId);
    }

    public List<Refund> fetchAllRefunds(String id, JSONObject request) throws RazorpayException {
        return this.getCollection(String.format("payments/%s/refunds", id), request);
    }

    public List<Refund> fetchAllRefunds(String id) throws RazorpayException {
        return this.fetchAllRefunds(id, null);
    }

    public List<Refund> fetchAllRefunds(JSONObject request) throws RazorpayException {
        return this.refundClient.fetchAll(request);
    }

    public List<Transfer> transfer(String id, JSONObject request) throws RazorpayException {
        Response response = ApiUtils.postRequest(String.format("payments/%s/transfers", id), request, this.auth);
        return this.processCollectionResponse(response);
    }

    public List<Transfer> fetchAllTransfers(String id) throws RazorpayException {
        return this.fetchAllTransfers(id, null);
    }

    public List<Transfer> fetchAllTransfers(String id, JSONObject request) throws RazorpayException {
        return this.getCollection(String.format("payments/%s/transfers", id), request);
    }

    public BankTransfer fetchBankTransfers(String id) throws RazorpayException {
        return (BankTransfer)this.get(String.format("payments/%s/bank_transfer", id), null);
    }
}

