/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import com.rabbitmq.stream.ByteCapacity;
import com.rabbitmq.stream.OffsetSpecification;
import com.rabbitmq.stream.StreamCreator;
import com.rabbitmq.stream.compression.Compression;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.text.StringCharacterIterator;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

class Utils {
    static final X509TrustManager TRUST_EVERYTHING_TRUST_MANAGER;
    static final Function<String, String> OPTION_TO_ENVIRONMENT_VARIABLE;
    static final Function<String, String> ENVIRONMENT_VARIABLE_PREFIX;
    static final Function<String, String> ENVIRONMENT_VARIABLE_LOOKUP;
    private static final LongSupplier TOTAL_MEMORY_SIZE_SUPPLIER;
    private static final Logger LOGGER;
    private static final String RANGE_SEPARATOR_1 = "-";
    private static final String RANGE_SEPARATOR_2 = "..";

    Utils() {
    }

    static void writeLong(byte[] array, long value) {
        for (int i = 7; i >= 0; --i) {
            array[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    static long readLong(byte[] array) {
        return ((long)array[0] & 0xFFL) << 56 | ((long)array[1] & 0xFFL) << 48 | ((long)array[2] & 0xFFL) << 40 | ((long)array[3] & 0xFFL) << 32 | ((long)array[4] & 0xFFL) << 24 | ((long)array[5] & 0xFFL) << 16 | ((long)array[6] & 0xFFL) << 8 | (long)array[7] & 0xFFL;
    }

    static List<String> streams(String range, List<String> streams) {
        String streamFormat;
        int to;
        int from;
        if (range.contains(RANGE_SEPARATOR_2)) {
            range = range.replace(RANGE_SEPARATOR_2, RANGE_SEPARATOR_1);
        }
        if (range.contains(RANGE_SEPARATOR_1)) {
            String[] fromTo = range.split(RANGE_SEPARATOR_1);
            from = Integer.parseInt(fromTo[0]);
            to = Integer.parseInt(fromTo[1]) + 1;
        } else {
            int count = Integer.parseInt(range);
            from = 1;
            to = count + 1;
        }
        if (from == 1 && to == 2) {
            return streams;
        }
        if (streams.size() != 1) {
            throw new IllegalArgumentException("Enter only 1 stream when --stream-count is specified");
        }
        String format = streams.get(0);
        if (!format.contains("%")) {
            int digits = String.valueOf(to - 1).length();
            streamFormat = format + "-%0" + digits + "d";
        } else {
            streamFormat = format;
        }
        return IntStream.range(from, to).mapToObj(i -> String.format(streamFormat, i)).collect(Collectors.toList());
    }

    static String formatByte(double bytes) {
        if (-1000.0 < bytes && bytes < 1000.0) {
            return String.valueOf(bytes);
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950.0 || bytes >= 999950.0) {
            bytes /= 1000.0;
            ci.next();
        }
        return String.format("%.1f %cB", bytes / 1000.0, Character.valueOf(ci.current()));
    }

    static long physicalMemory() {
        try {
            return TOTAL_MEMORY_SIZE_SUPPLIER.getAsLong();
        }
        catch (Throwable e) {
            LOGGER.warn("Could not get physical memory", e);
            return 0L;
        }
    }

    private static void throwConversionException(String format, String ... arguments) {
        throw new CommandLine.TypeConversionException(String.format(format, arguments));
    }

    static void assignValuesToCommand(Object command, Function<String, String> optionMapping) throws Exception {
        LOGGER.debug("Assigning values to command {}", command.getClass());
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<Field> fieldsToAssign = new ArrayList<Field>();
        for (Field field : command.getClass().getDeclaredFields()) {
            CommandLine.Option option = field.getAnnotation(CommandLine.Option.class);
            if (option == null) {
                LOGGER.debug("No option annotation for field {}", (Object)field.getName());
                continue;
            }
            String longOption = Arrays.stream(option.names()).sorted(Comparator.comparingInt(String::length).reversed()).findFirst().get();
            LOGGER.debug("Looking up new value for option {}", (Object)longOption);
            String newValue = optionMapping.apply(longOption);
            LOGGER.debug("New value found for option {} (field {}): {}", new Object[]{longOption, field.getName(), newValue});
            if (newValue == null) continue;
            fieldsToAssign.add(field);
            if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                if (!Boolean.parseBoolean(newValue)) continue;
                arguments.add(longOption);
                continue;
            }
            arguments.add(longOption + " " + newValue);
        }
        if (fieldsToAssign.size() > 0) {
            Constructor<?> defaultConstructor = command.getClass().getConstructor(new Class[0]);
            Object commandBuffer = defaultConstructor.newInstance(new Object[0]);
            String argumentsLine = String.join((CharSequence)" ", arguments);
            LOGGER.debug("Arguments line with extra values: {}", (Object)argumentsLine);
            String[] args = argumentsLine.split(" ");
            commandBuffer = CommandLine.populateCommand(commandBuffer, (String[])args);
            for (Field field : fieldsToAssign) {
                field.setAccessible(true);
                field.set(command, field.get(commandBuffer));
            }
        }
    }

    static CommandLine.Model.CommandSpec buildCommandSpec(Object ... commands) {
        Object mainCommand = commands[0];
        CommandLine.Command commandAnnotation = mainCommand.getClass().getAnnotation(CommandLine.Command.class);
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.create();
        spec.name(commandAnnotation.name());
        spec.mixinStandardHelpOptions(commandAnnotation.mixinStandardHelpOptions());
        for (Object command : commands) {
            for (Field f : command.getClass().getDeclaredFields()) {
                CommandLine.Option annotation = f.getAnnotation(CommandLine.Option.class);
                if (annotation == null) continue;
                String name = Arrays.stream(annotation.names()).sorted(Comparator.comparingInt(String::length).reversed()).findFirst().map(OPTION_TO_ENVIRONMENT_VARIABLE::apply).get();
                spec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).type(f.getType())).description(annotation.description())).paramLabel("<" + name.replace("_", RANGE_SEPARATOR_1) + ">")).defaultValue(annotation.defaultValue())).showDefaultValue(annotation.showDefaultValue())).build());
            }
        }
        return spec;
    }

    static {
        Method method;
        TRUST_EVERYTHING_TRUST_MANAGER = new TrustEverythingTrustManager();
        OPTION_TO_ENVIRONMENT_VARIABLE = option -> {
            if (option.startsWith("--")) {
                return option.replace("--", "").replace('-', '_').toUpperCase(Locale.ENGLISH);
            }
            if (option.startsWith(RANGE_SEPARATOR_1)) {
                return option.substring(1).replace('-', '_').toUpperCase(Locale.ENGLISH);
            }
            return option.replace('-', '_').toUpperCase(Locale.ENGLISH);
        };
        ENVIRONMENT_VARIABLE_PREFIX = name -> {
            String prefix = System.getenv("RABBITMQ_STREAM_PERF_TEST_ENV_PREFIX");
            if (prefix == null || prefix.trim().isEmpty()) {
                return name;
            }
            if (prefix.endsWith("_")) {
                return prefix + name;
            }
            return prefix + "_" + name;
        };
        ENVIRONMENT_VARIABLE_LOOKUP = name -> System.getenv(name);
        LOGGER = LoggerFactory.getLogger(Utils.class);
        try {
            method = OperatingSystemMXBean.class.getDeclaredMethod("getTotalMemorySize", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            try {
                method = OperatingSystemMXBean.class.getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while computing method to get total memory size");
            }
        }
        Method m = method;
        TOTAL_MEMORY_SIZE_SUPPLIER = () -> {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            try {
                return (Long)m.invoke((Object)os, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve total memory size", e);
            }
        };
    }

    static final class PatternNameStrategy
    implements BiFunction<String, Integer, String> {
        private final String pattern;

        PatternNameStrategy(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public String apply(String stream, Integer index) {
            return String.format(this.pattern, stream, index);
        }
    }

    private static class TrustEverythingTrustManager
    implements X509TrustManager {
        private TrustEverythingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory backingThreaFactory;
        private final String prefix;
        private final AtomicLong count = new AtomicLong(0L);

        public NamedThreadFactory(String prefix) {
            this(Executors.defaultThreadFactory(), prefix);
        }

        public NamedThreadFactory(ThreadFactory backingThreadFactory, String prefix) {
            this.backingThreaFactory = backingThreadFactory;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.backingThreaFactory.newThread(r);
            thread.setName(this.prefix + this.count.getAndIncrement());
            return thread;
        }
    }

    static class NotNegativeIntegerTypeConverter
    implements CommandLine.ITypeConverter<Integer> {
        NotNegativeIntegerTypeConverter() {
        }

        public Integer convert(String input) {
            try {
                Integer value = Integer.valueOf(input);
                if (value < 0) {
                    throw new IllegalArgumentException();
                }
                return value;
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(input + " is not a non-negative integer");
            }
        }
    }

    static class OneTo255RangeIntegerTypeConverter
    extends RangeIntegerTypeConverter {
        OneTo255RangeIntegerTypeConverter() {
            super(1, 255);
        }
    }

    private static abstract class RangeIntegerTypeConverter
    implements CommandLine.ITypeConverter<Integer> {
        private final int min;
        private final int max;

        private RangeIntegerTypeConverter(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public Integer convert(String input) {
            try {
                Integer value = Integer.valueOf(input);
                if (value < this.min || value > this.max) {
                    throw new IllegalArgumentException();
                }
                return value;
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(input + " must an integer between " + this.min + " and " + this.max);
            }
        }
    }

    static class CompressionTypeConverter
    implements CommandLine.ITypeConverter<Compression> {
        CompressionTypeConverter() {
        }

        public Compression convert(String input) {
            try {
                return Compression.valueOf(input.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(input + " is not a valid compression value. Accepted values are " + Arrays.stream(Compression.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ")) + ".");
            }
        }
    }

    static class PositiveIntegerTypeConverter
    implements CommandLine.ITypeConverter<Integer> {
        PositiveIntegerTypeConverter() {
        }

        public Integer convert(String input) {
            try {
                Integer value = Integer.valueOf(input);
                if (value <= 0) {
                    throw new IllegalArgumentException();
                }
                return value;
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(input + " is not a positive integer");
            }
        }
    }

    static class OffsetSpecificationTypeConverter
    implements CommandLine.ITypeConverter<OffsetSpecification> {
        private static final Map<String, OffsetSpecification> SPECS = Collections.unmodifiableMap(new HashMap<String, OffsetSpecification>(){
            {
                this.put("first", OffsetSpecification.first());
                this.put("last", OffsetSpecification.last());
                this.put("next", OffsetSpecification.next());
            }
        });

        OffsetSpecificationTypeConverter() {
        }

        public OffsetSpecification convert(String value) throws Exception {
            if (value == null || value.trim().isEmpty()) {
                return OffsetSpecification.first();
            }
            if (SPECS.containsKey(value.toLowerCase())) {
                return SPECS.get(value.toLowerCase());
            }
            try {
                long offset = Long.parseUnsignedLong(value);
                return OffsetSpecification.offset(offset);
            }
            catch (NumberFormatException offset) {
                try {
                    TemporalAccessor accessor = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value);
                    return OffsetSpecification.timestamp(Instant.from(accessor).toEpochMilli());
                }
                catch (DateTimeParseException e) {
                    throw new CommandLine.TypeConversionException("'" + value + "' is not a valid offset value, valid values are 'first', 'last', 'next', an unsigned long, or an ISO 8601 formatted timestamp (eg. 2020-06-03T07:45:54Z)");
                }
            }
        }
    }

    static class LeaderLocatorTypeConverter
    implements CommandLine.ITypeConverter<StreamCreator.LeaderLocator> {
        LeaderLocatorTypeConverter() {
        }

        public StreamCreator.LeaderLocator convert(String value) {
            try {
                return StreamCreator.LeaderLocator.from(value);
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException("'" + value + "' is not valid, possible values: " + Arrays.stream(StreamCreator.LeaderLocator.values()).map(ll -> ll.value()).collect(Collectors.joining(", ")));
            }
        }
    }

    static class DurationTypeConverter
    implements CommandLine.ITypeConverter<Duration> {
        DurationTypeConverter() {
        }

        public Duration convert(String value) {
            try {
                Duration duration = Duration.parse(value);
                if (duration.isNegative() || duration.isZero()) {
                    throw new CommandLine.TypeConversionException("'" + value + "' is not valid, it must be positive");
                }
                return duration;
            }
            catch (DateTimeParseException e) {
                throw new CommandLine.TypeConversionException("'" + value + "' is not valid, valid example values: PT15M, PT10H");
            }
        }
    }

    static class RangeTypeConverter
    implements CommandLine.ITypeConverter<String> {
        RangeTypeConverter() {
        }

        public String convert(String input) {
            String value = input.contains(Utils.RANGE_SEPARATOR_2) ? input.replace(Utils.RANGE_SEPARATOR_2, Utils.RANGE_SEPARATOR_1) : input;
            if (value.contains(Utils.RANGE_SEPARATOR_1)) {
                String[] fromTo = value.split(Utils.RANGE_SEPARATOR_1);
                if (fromTo == null || fromTo.length != 2) {
                    Utils.throwConversionException("'%s' is not valid, valid examples values: 10, 1-10", new String[]{input});
                }
                Arrays.stream(fromTo).forEach(v -> {
                    try {
                        int i = Integer.parseInt(v);
                        if (i <= 0) {
                            Utils.throwConversionException("'%s' is not valid, the value must be a positive integer", new String[]{v});
                        }
                    }
                    catch (NumberFormatException e) {
                        Utils.throwConversionException("'%s' is not valid, the value must be a positive integer", new String[]{v});
                    }
                });
                int from = Integer.parseInt(fromTo[0]);
                int to = Integer.parseInt(fromTo[1]);
                if (from >= to) {
                    Utils.throwConversionException("'%s' is not valid, valid examples values: 10, 1-10", new String[]{input});
                }
            } else {
                try {
                    int count = Integer.parseInt(value);
                    if (count <= 0) {
                        Utils.throwConversionException("'%s' is not valid, the value must be a positive integer", new String[]{input});
                    }
                }
                catch (NumberFormatException e) {
                    Utils.throwConversionException("'%s' is not valid, valid example values: 10, 1-10", new String[]{input});
                }
            }
            return input;
        }
    }

    static class SniServerNamesConverter
    implements CommandLine.ITypeConverter<List<SNIServerName>> {
        SniServerNamesConverter() {
        }

        public List<SNIServerName> convert(String value) throws Exception {
            if (value == null || value.trim().isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.stream(value.split(",")).map(s -> s.trim()).map(s -> new SNIHostName((String)s)).collect(Collectors.toList());
        }
    }

    static class NameStrategyConverter
    implements CommandLine.ITypeConverter<BiFunction<String, Integer, String>> {
        NameStrategyConverter() {
        }

        public BiFunction<String, Integer, String> convert(String input) {
            if ("uuid".equals(input)) {
                return (stream, index) -> UUID.randomUUID().toString();
            }
            return new PatternNameStrategy(input);
        }
    }

    static class ByteCapacityTypeConverter
    implements CommandLine.ITypeConverter<ByteCapacity> {
        ByteCapacityTypeConverter() {
        }

        public ByteCapacity convert(String value) {
            try {
                return ByteCapacity.from(value);
            }
            catch (IllegalArgumentException e) {
                throw new CommandLine.TypeConversionException("'" + value + "' is not valid, valid example values: 100gb, 50mb");
            }
        }
    }
}

