/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientProperties.class);
    private static final char[] VERSION_PROPERTY = new char[]{'c', 'o', 'm', '.', 'r', 'a', 'b', 'b', 'i', 't', 'm', 'q', '.', 's', 't', 'r', 'e', 'a', 'm', '.', 'c', 'l', 'i', 'e', 'n', 't', '.', 'v', 'e', 'r', 's', 'i', 'o', 'n'};
    public static final String VERSION = ClientProperties.getVersion();
    public static final Map<String, String> DEFAULT_CLIENT_PROPERTIES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("product", "RabbitMQ Stream");
            this.put("version", VERSION);
            this.put("platform", "Java");
            this.put("copyright", "Copyright (c) 2020-2021 VMware, Inc. or its affiliates.");
            this.put("information", "Licensed under the MPL 2.0. See https://www.rabbitmq.com/");
        }
    });

    private static String getVersion() {
        String version;
        try {
            version = ClientProperties.getVersionFromPropertyFile();
        }
        catch (Exception e1) {
            LOGGER.warn("Couldn't get version from property file", (Throwable)e1);
            try {
                version = ClientProperties.getVersionFromPackage();
            }
            catch (Exception e2) {
                LOGGER.warn("Couldn't get version with Package#getImplementationVersion", (Throwable)e1);
                version = ClientProperties.getDefaultVersion();
            }
        }
        return version;
    }

    private static String getVersionFromPropertyFile() throws Exception {
        Properties version = new Properties();
        try (InputStream inputStream = ClientProperties.class.getClassLoader().getResourceAsStream("rabbitmq-stream-client.properties");){
            version.load(inputStream);
        }
        String propertyName = new String(VERSION_PROPERTY);
        String versionProperty = version.getProperty(propertyName);
        if (versionProperty == null) {
            throw new IllegalStateException("Couldn't find version property in property file");
        }
        return versionProperty;
    }

    private static String getVersionFromPackage() {
        if (ClientProperties.class.getPackage().getImplementationVersion() == null) {
            throw new IllegalStateException("Couldn't get version with Package#getImplementationVersion");
        }
        return ClientProperties.class.getPackage().getImplementationVersion();
    }

    private static String getDefaultVersion() {
        return "0.0.0";
    }

    private ClientProperties() {
    }
}

