/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.observation.micrometer;

import com.rabbitmq.stream.Message;
import io.micrometer.observation.transport.SenderContext;

public class PublishContext
extends SenderContext<Message> {
    private final String stream;
    private final int payloadSizeBytes;

    PublishContext(String stream, Message message) {
        super((carrier, key, value) -> carrier.annotate(key, value));
        int payloadSize;
        this.stream = stream;
        try {
            byte[] body = message.getBodyAsBinary();
            payloadSize = body == null ? 0 : body.length;
        }
        catch (Exception e) {
            payloadSize = 0;
        }
        this.payloadSizeBytes = payloadSize;
        this.setCarrier(message);
    }

    public String stream() {
        return this.stream;
    }

    public int getPayloadSizeBytes() {
        return this.payloadSizeBytes;
    }
}

