/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadPart;
import com.qcloud.cos.transfer.PersistableResumeDownload;
import com.qcloud.cos.transfer.ResumableDownloadSubmitter;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferMonitor;
import com.qcloud.cos.utils.CRC64;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableDownloadMonitor
implements Callable<File>,
TransferMonitor {
    private static final Logger log = LoggerFactory.getLogger(ResumableDownloadMonitor.class);
    private final ProgressListenerChain listener;
    private final ResumableDownloadSubmitter downloadSubmitter;
    private final DownloadImpl transfer;
    private final PersistableResumeDownload downloadRecord;
    private final File destFile;
    private final List<Future<DownloadPart>> futures = Collections.synchronizedList(new ArrayList());
    private boolean isDownloadDone = false;
    private AtomicReference<Future<File>> futureReference = new AtomicReference<Object>(null);

    public Future<File> getFuture() {
        return this.futureReference.get();
    }

    private synchronized void cancelFuture() {
        this.futureReference.get().cancel(true);
    }

    ResumableDownloadMonitor(ProgressListenerChain listener, ResumableDownloadSubmitter downloadSubmitter, DownloadImpl transfer, PersistableResumeDownload downloadRecord, File destFile) {
        this.listener = listener;
        this.downloadSubmitter = downloadSubmitter;
        this.transfer = transfer;
        this.downloadRecord = downloadRecord;
        this.destFile = destFile;
    }

    public static ResumableDownloadMonitor create(ProgressListenerChain listener, ResumableDownloadSubmitter downloadSubmitter, DownloadImpl transfer, ExecutorService threadPool, PersistableResumeDownload downloadRecord, File destFile) {
        ResumableDownloadMonitor monitor = new ResumableDownloadMonitor(listener, downloadSubmitter, transfer, downloadRecord, destFile);
        monitor.futureReference.compareAndSet(null, threadPool.submit(monitor));
        return monitor;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isDownloadDone;
    }

    private synchronized void markAllDone() {
        this.isDownloadDone = true;
    }

    @Override
    public File call() throws Exception {
        this.downloadSubmitter.submit();
        this.futures.addAll(this.downloadSubmitter.getFutures());
        ArrayList<DownloadPart> downloadParts = new ArrayList<DownloadPart>();
        downloadParts.addAll(this.downloadSubmitter.getSkippedParts());
        try {
            for (Future<DownloadPart> future : this.futures) {
                try {
                    downloadParts.add(future.get());
                }
                catch (Exception e) {
                    throw new CosClientException("range download got exception: " + e.getCause().getMessage() + e.getMessage());
                }
            }
            this.downloadRecord.getDumpFile().delete();
            if (this.downloadRecord.getCrc64ecma() != null && !this.downloadRecord.getCrc64ecma().isEmpty()) {
                this.checkCRC(downloadParts);
            }
            this.downloadComplete();
            return this.destFile;
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new CosClientException("Download canceled");
        }
        catch (Exception e) {
            this.downloadFailed();
            throw e;
        }
    }

    void downloadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
    }

    void downloadFailed() {
        this.transfer.setState(Transfer.TransferState.Failed);
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
    }

    private void cancelFutures() {
        this.cancelFuture();
        if (this.futures.size() == 0) {
            this.futures.addAll(this.downloadSubmitter.getFutures());
        }
        for (Future<DownloadPart> f : this.futures) {
            f.cancel(true);
        }
        this.futures.clear();
    }

    void performAbort() {
        this.cancelFutures();
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
    }

    void checkCRC(List<DownloadPart> downloadParts) throws IOException {
        Collections.sort(downloadParts, new Comparator<DownloadPart>(){

            @Override
            public int compare(DownloadPart part1, DownloadPart part2) {
                return (int)(part1.start - part2.start);
            }
        });
        CRC64 crc64 = new CRC64();
        for (DownloadPart part : downloadParts) {
            crc64 = CRC64.combine(crc64, new CRC64(part.crc64), part.getContentLength());
        }
        long crc64Download = crc64.getValue();
        long crc64Cos = this.crc64ToLong(this.downloadRecord.getCrc64ecma());
        log.debug("download crc " + crc64Download + " cos crc " + crc64Cos);
        if (crc64Download != crc64Cos) {
            this.destFile.delete();
            throw new CosClientException("download file has diff crc64 with cos file, cos: " + crc64Cos + " downloaded: " + crc64Download);
        }
    }

    long crc64ToLong(String crc64) {
        if (crc64.charAt(0) == '-') {
            return this.negativeCrc64ToLong(crc64);
        }
        return this.positiveCrc64ToLong(crc64);
    }

    long positiveCrc64ToLong(String strCrc64) {
        BigInteger crc64 = new BigInteger(strCrc64);
        BigInteger maxLong = new BigInteger(Long.toString(Long.MAX_VALUE));
        int maxCnt = 0;
        while (crc64.compareTo(maxLong) > 0) {
            crc64 = crc64.subtract(maxLong);
            ++maxCnt;
        }
        return crc64.longValue() + Long.MAX_VALUE * (long)maxCnt;
    }

    long negativeCrc64ToLong(String strCrc64) {
        BigInteger crc64 = new BigInteger(strCrc64);
        BigInteger minLong = new BigInteger(Long.toString(Long.MIN_VALUE));
        int minCnt = 0;
        while (crc64.compareTo(minLong) < 0) {
            crc64 = crc64.subtract(minLong);
            ++minCnt;
        }
        return crc64.longValue() + Long.MIN_VALUE * (long)minCnt;
    }
}

