/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.CASJobParameters;
import com.qcloud.cos.model.CSVInput;
import com.qcloud.cos.model.CSVOutput;
import com.qcloud.cos.model.InputSerialization;
import com.qcloud.cos.model.JSONInput;
import com.qcloud.cos.model.JSONOutput;
import com.qcloud.cos.model.OutputSerialization;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.RequestProgress;
import com.qcloud.cos.model.RestoreObjectRequest;
import com.qcloud.cos.model.ScanRange;
import com.qcloud.cos.model.SelectObjectContentRequest;
import com.qcloud.cos.model.SelectParameters;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.Conf;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.DocJobObject;
import com.qcloud.cos.model.ciModel.job.DocJobRequest;
import com.qcloud.cos.model.ciModel.job.DocProcessObject;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoRequest;
import com.qcloud.cos.model.ciModel.queue.DocQueueRequest;
import com.qcloud.cos.model.ciModel.queue.MediaQueueRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotRequest;
import com.qcloud.cos.model.ciModel.template.MediaSnapshotObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import com.qcloud.cos.model.ciModel.workflow.MediaOperation;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowDependency;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowNode;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowRequest;
import com.qcloud.cos.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class RequestXmlFactory {
    public static byte[] convertToXmlByteArray(List<PartETag> partETags) {
        XmlWriter xml = new XmlWriter();
        xml.start("CompleteMultipartUpload");
        if (partETags != null) {
            Collections.sort(partETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag tag1, PartETag tag2) {
                    if (tag1.getPartNumber() < tag2.getPartNumber()) {
                        return -1;
                    }
                    if (tag1.getPartNumber() > tag2.getPartNumber()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (PartETag partEtag : partETags) {
                xml.start("Part");
                xml.start("PartNumber").value(Integer.toString(partEtag.getPartNumber())).end();
                xml.start("ETag").value(partEtag.getETag()).end();
                xml.end();
            }
        }
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(SelectObjectContentRequest selectRequest) {
        XmlWriter xml = new XmlWriter();
        xml.start("SelectObjectContentRequest");
        RequestXmlFactory.addIfNotNull(xml, "Expression", selectRequest.getExpression());
        RequestXmlFactory.addIfNotNull(xml, "ExpressionType", selectRequest.getExpressionType());
        RequestXmlFactory.addScanRangeIfNotNull(xml, selectRequest.getScanRange());
        RequestXmlFactory.addRequestProgressIfNotNull(xml, selectRequest.getRequestProgress());
        RequestXmlFactory.addInputSerializationIfNotNull(xml, selectRequest.getInputSerialization());
        RequestXmlFactory.addOutputSerializationIfNotNull(xml, selectRequest.getOutputSerialization());
        xml.end();
        return xml.getBytes();
    }

    private static void addRequestProgressIfNotNull(XmlWriter xml, RequestProgress requestProgress) {
        if (requestProgress == null) {
            return;
        }
        xml.start("RequestProgress");
        RequestXmlFactory.addIfNotNull(xml, "Enabled", requestProgress.getEnabled());
        xml.end();
    }

    private static void addSelectParametersIfNotNull(XmlWriter xml, SelectParameters selectParameters) {
        if (selectParameters == null) {
            return;
        }
        xml.start("SelectParameters");
        RequestXmlFactory.addInputSerializationIfNotNull(xml, selectParameters.getInputSerialization());
        RequestXmlFactory.addIfNotNull(xml, "ExpressionType", selectParameters.getExpressionType());
        RequestXmlFactory.addIfNotNull(xml, "Expression", selectParameters.getExpression());
        RequestXmlFactory.addOutputSerializationIfNotNull(xml, selectParameters.getOutputSerialization());
        xml.end();
    }

    private static void addScanRangeIfNotNull(XmlWriter xml, ScanRange scanRange) {
        if (scanRange != null) {
            xml.start("ScanRange");
            RequestXmlFactory.addIfNotNull(xml, "Start", scanRange.getStart());
            RequestXmlFactory.addIfNotNull(xml, "End", scanRange.getEnd());
            xml.end();
        }
    }

    private static void addInputSerializationIfNotNull(XmlWriter xml, InputSerialization inputSerialization) {
        if (inputSerialization != null) {
            xml.start("InputSerialization");
            if (inputSerialization.getCsv() != null) {
                xml.start("CSV");
                CSVInput csvInput = inputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xml, "FileHeaderInfo", csvInput.getFileHeaderInfo());
                RequestXmlFactory.addIfNotNull(xml, "Comments", csvInput.getCommentsAsString());
                RequestXmlFactory.addIfNotNull(xml, "QuoteEscapeCharacter", csvInput.getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xml, "RecordDelimiter", csvInput.getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "FieldDelimiter", csvInput.getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "QuoteCharacter", csvInput.getQuoteCharacterAsString());
                RequestXmlFactory.addIfNotNull(xml, "AllowQuotedRecordDelimiter", csvInput.getAllowQuotedRecordDelimiter());
                xml.end();
            }
            if (inputSerialization.getJson() != null) {
                xml.start("JSON");
                JSONInput jsonInput = inputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xml, "Type", jsonInput.getType());
                xml.end();
            }
            if (inputSerialization.getParquet() != null) {
                xml.start("Parquet");
                xml.end();
            }
            RequestXmlFactory.addIfNotNull(xml, "CompressionType", inputSerialization.getCompressionType());
            xml.end();
        }
    }

    private static void addOutputSerializationIfNotNull(XmlWriter xml, OutputSerialization outputSerialization) {
        if (outputSerialization != null) {
            xml.start("OutputSerialization");
            if (outputSerialization.getCsv() != null) {
                xml.start("CSV");
                CSVOutput csvOutput = outputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xml, "QuoteFields", csvOutput.getQuoteFields());
                RequestXmlFactory.addIfNotNull(xml, "QuoteEscapeCharacter", csvOutput.getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xml, "RecordDelimiter", csvOutput.getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "FieldDelimiter", csvOutput.getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "QuoteCharacter", csvOutput.getQuoteCharacterAsString());
                xml.end();
            }
            if (outputSerialization.getJson() != null) {
                xml.start("JSON");
                JSONOutput jsonOutput = outputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xml, "RecordDelimiter", jsonOutput.getRecordDelimiterAsString());
                xml.end();
            }
            xml.end();
        }
    }

    public static byte[] convertToXmlByteArray(RestoreObjectRequest restoreObjectRequest) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("RestoreRequest");
        xml.start("Days").value(Integer.toString(restoreObjectRequest.getExpirationInDays())).end();
        CASJobParameters casJobParameters = restoreObjectRequest.getCasJobParameters();
        if (casJobParameters != null) {
            xml.start("CASJobParameters");
            RequestXmlFactory.addIfNotNull(xml, "Tier", casJobParameters.getTier());
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaWorkflowRequest request) throws CosClientException, UnsupportedEncodingException {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("MediaWorkflow");
        xml.start("Name").value(request.getName()).end();
        RequestXmlFactory.addIfNotNull(xml, "State", request.getState());
        RequestXmlFactory.addIfNotNull(xml, "WorkflowId", request.getWorkflowId());
        xml.start("Topology");
        xml.start("Dependencies");
        Map<String, MediaWorkflowDependency> mediaWorkflowDependency = request.getTopology().getMediaWorkflowDependency();
        for (String key : mediaWorkflowDependency.keySet()) {
            xml.start(key).value(mediaWorkflowDependency.get(key).getValue()).end();
        }
        xml.end();
        xml.start("Nodes");
        Map<String, MediaWorkflowNode> mediaWorkflowNodes = request.getTopology().getMediaWorkflowNodes();
        for (String key : mediaWorkflowNodes.keySet()) {
            xml.start(key);
            MediaWorkflowNode mediaWorkflowNode = mediaWorkflowNodes.get(key);
            xml.start("Type").value(mediaWorkflowNode.getType()).end();
            if (mediaWorkflowNode.getInput().getObjectPrefix() != null || mediaWorkflowNode.getInput().getQueueId() != null) {
                xml.start("Input");
                RequestXmlFactory.addIfNotNull(xml, "QueueId", mediaWorkflowNode.getInput().getQueueId());
                RequestXmlFactory.addIfNotNull(xml, "ObjectPrefix", mediaWorkflowNode.getInput().getObjectPrefix());
                xml.end();
            }
            MediaOperation operation = mediaWorkflowNode.getOperation();
            MediaOutputObject output = operation.getOutput();
            if (operation.getTemplateId() != null || output.getBucket() != null || output.getObject() != null || output.getRegion() != null) {
                xml.start("Operation");
                RequestXmlFactory.addIfNotNull(xml, "TemplateId", operation.getTemplateId());
                xml.start("Output");
                RequestXmlFactory.addIfNotNull(xml, "Region", output.getRegion());
                RequestXmlFactory.addIfNotNull(xml, "Bucket", output.getBucket());
                RequestXmlFactory.addIfNotNull(xml, "Object", output.getObject());
                xml.end();
                xml.end();
            }
            xml.end();
        }
        xml.end();
        xml.end();
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaJobsRequest request) {
        String format;
        MediaConcatTemplateObject mediaConcatTemplate;
        MediaRemoveWaterMark removeWatermark;
        MediaWatermark watermark;
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Tag").value(request.getTag()).end();
        xml.start("BucketName").value(request.getBucketName()).end();
        xml.start("Input");
        xml.start("Object").value(request.getInput().getObject()).end();
        xml.end();
        MediaJobOperation operation = request.getOperation();
        xml.start("Operation");
        RequestXmlFactory.addIfNotNull(xml, "TemplateId", operation.getTemplateId());
        List<String> watermarkTemplateId = operation.getWatermarkTemplateId();
        if (watermarkTemplateId.size() != 0) {
            for (String templateId : watermarkTemplateId) {
                xml.start("WatermarkTemplateId").value(templateId).end();
            }
        }
        if (CheckObjectUtils.objIsNotValid(watermark = operation.getWatermark()).booleanValue()) {
            RequestXmlFactory.addIfNotNull(xml, "Type", watermark.getType());
            RequestXmlFactory.addIfNotNull(xml, "Dx", watermark.getDx());
            RequestXmlFactory.addIfNotNull(xml, "Dy", watermark.getDy());
            RequestXmlFactory.addIfNotNull(xml, "EndTime", watermark.getEndTime());
            RequestXmlFactory.addIfNotNull(xml, "LocMode", watermark.getLocMode());
            RequestXmlFactory.addIfNotNull(xml, "Pos", watermark.getPos());
            RequestXmlFactory.addIfNotNull(xml, "StartTime", watermark.getStartTime());
            if ("Text".equalsIgnoreCase(watermark.getType())) {
                MediaWaterMarkText text = watermark.getText();
                xml.start("Text");
                RequestXmlFactory.addIfNotNull(xml, "FontColor", text.getFontColor());
                RequestXmlFactory.addIfNotNull(xml, "FontSize", text.getFontSize());
                RequestXmlFactory.addIfNotNull(xml, "FontType", text.getFontType());
                RequestXmlFactory.addIfNotNull(xml, "Text", text.getText());
                RequestXmlFactory.addIfNotNull(xml, "Transparency", text.getTransparency());
                xml.end();
            } else if ("Image".equalsIgnoreCase(watermark.getType())) {
                MediaWaterMarkImage image = watermark.getImage();
                xml.start("Image");
                RequestXmlFactory.addIfNotNull(xml, "Height", image.getHeight());
                RequestXmlFactory.addIfNotNull(xml, "Mode", image.getMode());
                RequestXmlFactory.addIfNotNull(xml, "Transparency", image.getTransparency());
                RequestXmlFactory.addIfNotNull(xml, "Url", image.getUrl());
                RequestXmlFactory.addIfNotNull(xml, "Width", image.getWidth());
                xml.end();
            }
        }
        if (CheckObjectUtils.objIsNotValid(removeWatermark = operation.getRemoveWatermark()).booleanValue()) {
            xml.start("RemoveWatermark");
            RequestXmlFactory.addIfNotNull(xml, "Height", removeWatermark.getHeight());
            RequestXmlFactory.addIfNotNull(xml, "Dx", removeWatermark.getDx());
            RequestXmlFactory.addIfNotNull(xml, "Dy", removeWatermark.getDy());
            RequestXmlFactory.addIfNotNull(xml, "Switch", removeWatermark.get_switch());
            RequestXmlFactory.addIfNotNull(xml, "Width", removeWatermark.getWidth());
            xml.end();
        }
        if (CheckObjectUtils.objIsNotValid(mediaConcatTemplate = operation.getMediaConcatTemplate()).booleanValue()) {
            xml.start("ConcatTemplate");
            List<MediaConcatFragmentObject> concatFragmentList = mediaConcatTemplate.getConcatFragmentList();
            for (MediaConcatFragmentObject concatFragment : concatFragmentList) {
                xml.start("ConcatFragment");
                RequestXmlFactory.addIfNotNull(xml, "Mode", concatFragment.getMode());
                RequestXmlFactory.addIfNotNull(xml, "Url", concatFragment.getUrl());
                xml.end();
            }
            RequestXmlFactory.addVideo(xml, mediaConcatTemplate.getVideo());
            RequestXmlFactory.addAudio(xml, mediaConcatTemplate.getAudio());
            RequestXmlFactory.addIfNotNull(xml, "Index", mediaConcatTemplate.getIndex());
            format = mediaConcatTemplate.getContainer().getFormat();
            if (!StringUtils.isNullOrEmpty(format)) {
                xml.start("Container");
                xml.start("Format").value(format).end();
                xml.end();
            }
            xml.end();
        }
        MediaTranscodeObject transcode = operation.getTranscode();
        format = transcode.getContainer().getFormat();
        if (CheckObjectUtils.objIsNotValid(transcode).booleanValue() && !StringUtils.isNullOrEmpty(format)) {
            xml.start("Transcode");
            MediaTranscodeVideoObject video = transcode.getVideo();
            MediaAudioObject audio = transcode.getAudio();
            MediaTransConfigObject transConfig = transcode.getTransConfig();
            MediaTimeIntervalObject timeInterval = transcode.getTimeInterval();
            if (format != null) {
                xml.start("Container");
                xml.start("Format").value(format).end();
                xml.end();
            }
            if (CheckObjectUtils.objIsNotValid(timeInterval).booleanValue()) {
                xml.start("TimeInterval");
                xml.start("Duration").value(timeInterval.getDuration()).end();
                xml.start("Start").value(timeInterval.getStart()).end();
                xml.end();
            }
            if (CheckObjectUtils.objIsNotValid(video).booleanValue()) {
                RequestXmlFactory.addVideo(xml, video);
            }
            if (CheckObjectUtils.objIsNotValid(audio).booleanValue()) {
                RequestXmlFactory.addAudio(xml, audio);
            }
            if (CheckObjectUtils.objIsNotValid(transConfig).booleanValue()) {
                xml.start("TransConfig");
                RequestXmlFactory.addIfNotNull(xml, "AdjDarMethod", transConfig.getAdjDarMethod());
                RequestXmlFactory.addIfNotNull(xml, "AudioBitrateAdjMethod", transConfig.getAudioBitrateAdjMethod());
                RequestXmlFactory.addIfNotNull(xml, "IsCheckAudioBitrate", transConfig.getIsCheckAudioBitrate());
                RequestXmlFactory.addIfNotNull(xml, "IsCheckReso", transConfig.getIsCheckReso());
                RequestXmlFactory.addIfNotNull(xml, "IsCheckVideoBitrate", transConfig.getIsCheckVideoBitrate());
                RequestXmlFactory.addIfNotNull(xml, "ResoAdjMethod", transConfig.getResoAdjMethod());
                RequestXmlFactory.addIfNotNull(xml, "TransMode", transConfig.getTransMode());
                RequestXmlFactory.addIfNotNull(xml, "VideoBitrateAdjMethod", transConfig.getVideoBitrateAdjMethod());
                xml.end();
            }
            xml.end();
        }
        xml.start("Output");
        xml.start("Region").value(operation.getOutput().getRegion()).end();
        xml.start("Object").value(operation.getOutput().getObject()).end();
        xml.start("Bucket").value(operation.getOutput().getBucket()).end();
        xml.end();
        xml.end();
        xml.start("QueueId").value(request.getQueueId()).end();
        RequestXmlFactory.addIfNotNull(xml, "CallBack", request.getCallBack());
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaQueueRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Name").value(request.getName()).end();
        xml.start("QueueId").value(request.getQueueId()).end();
        xml.start("State").value(request.getState()).end();
        xml.start("NotifyConfig");
        RequestXmlFactory.addIfNotNull(xml, "Type", request.getNotifyConfig().getType());
        RequestXmlFactory.addIfNotNull(xml, "Url", request.getNotifyConfig().getUrl());
        RequestXmlFactory.addIfNotNull(xml, "Event", request.getNotifyConfig().getEvent());
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(SnapshotRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Input");
        xml.start("Object").value(request.getInput().getObject()).end();
        xml.end();
        xml.start("Output");
        xml.start("Region").value(request.getOutput().getRegion()).end();
        xml.start("Object").value(request.getOutput().getObject()).end();
        xml.start("Bucket").value(request.getOutput().getBucket()).end();
        xml.end();
        RequestXmlFactory.addIfNotNull(xml, "Time", request.getTime());
        RequestXmlFactory.addIfNotNull(xml, "Format", request.getFormat());
        RequestXmlFactory.addIfNotNull(xml, "Height", request.getHeight());
        RequestXmlFactory.addIfNotNull(xml, "Mode", request.getMode());
        RequestXmlFactory.addIfNotNull(xml, "Rotate", request.getRotate());
        RequestXmlFactory.addIfNotNull(xml, "Width", request.getWidth());
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaTemplateRequest request) {
        XmlWriter xml = new XmlWriter();
        String tag = request.getTag();
        xml.start("Request");
        xml.start("Tag").value(tag).end();
        xml.start("Name").value(request.getName()).end();
        if ("Animation".equalsIgnoreCase(tag)) {
            xml.start("Container");
            xml.start("Format").value(request.getContainer().getFormat()).end();
            xml.end();
            RequestXmlFactory.addVideo(xml, request);
            if (CheckObjectUtils.objIsNotValid(request.getTimeInterval()).booleanValue()) {
                xml.start("TimeInterval");
                xml.start("Duration").value(request.getTimeInterval().getDuration()).end();
                xml.start("Start").value(request.getTimeInterval().getStart()).end();
                xml.end();
            }
        } else if ("Snapshot".equalsIgnoreCase(tag)) {
            if (CheckObjectUtils.objIsNotValid(request.getSnapshot()).booleanValue()) {
                xml.start("Snapshot");
                MediaSnapshotObject snapshot = request.getSnapshot();
                RequestXmlFactory.addIfNotNull(xml, "Mode", snapshot.getMode());
                RequestXmlFactory.addIfNotNull(xml, "Count", snapshot.getCount());
                RequestXmlFactory.addIfNotNull(xml, "Fps", snapshot.getFps());
                RequestXmlFactory.addIfNotNull(xml, "Height", snapshot.getHeight());
                RequestXmlFactory.addIfNotNull(xml, "Start", snapshot.getStart());
                RequestXmlFactory.addIfNotNull(xml, "TimeInterval", snapshot.getTimeInterval());
                RequestXmlFactory.addIfNotNull(xml, "Width", snapshot.getWidth());
                xml.end();
            }
        } else if ("Watermark".equalsIgnoreCase(tag)) {
            xml.start("Watermark");
            RequestXmlFactory.addIfNotNull(xml, "Type", request.getWatermark().getType());
            RequestXmlFactory.addIfNotNull(xml, "Dx", request.getWatermark().getDx());
            RequestXmlFactory.addIfNotNull(xml, "Dy", request.getWatermark().getDy());
            RequestXmlFactory.addIfNotNull(xml, "EndTime", request.getWatermark().getEndTime());
            RequestXmlFactory.addIfNotNull(xml, "LocMode", request.getWatermark().getLocMode());
            RequestXmlFactory.addIfNotNull(xml, "Pos", request.getWatermark().getPos());
            RequestXmlFactory.addIfNotNull(xml, "StartTime", request.getWatermark().getStartTime());
            if ("Text".equalsIgnoreCase(request.getWatermark().getType())) {
                xml.start("Text");
                MediaWaterMarkText text = request.getWatermark().getText();
                RequestXmlFactory.addIfNotNull(xml, "FontColor", text.getFontColor());
                RequestXmlFactory.addIfNotNull(xml, "FontSize", text.getFontSize());
                RequestXmlFactory.addIfNotNull(xml, "FontType", text.getFontType());
                RequestXmlFactory.addIfNotNull(xml, "Text", text.getText());
                RequestXmlFactory.addIfNotNull(xml, "Transparency", text.getTransparency());
                xml.end();
            } else if ("Image".equalsIgnoreCase(request.getWatermark().getType())) {
                xml.start("Image");
                MediaWaterMarkImage image = request.getWatermark().getImage();
                RequestXmlFactory.addIfNotNull(xml, "Height", image.getHeight());
                RequestXmlFactory.addIfNotNull(xml, "Mode", image.getMode());
                RequestXmlFactory.addIfNotNull(xml, "Url", image.getUrl());
                RequestXmlFactory.addIfNotNull(xml, "Transparency", image.getTransparency());
                RequestXmlFactory.addIfNotNull(xml, "Width", image.getWidth());
                xml.end();
            }
            xml.end();
        } else if ("Transcode".equalsIgnoreCase(tag)) {
            xml.start("Container");
            xml.start("Format").value(request.getContainer().getFormat()).end();
            xml.end();
            xml.start("TimeInterval");
            xml.start("Duration").value(request.getTimeInterval().getDuration()).end();
            xml.start("Start").value(request.getTimeInterval().getStart()).end();
            xml.end();
            RequestXmlFactory.addAudio(xml, request.getAudio());
            xml.start("TransConfig");
            RequestXmlFactory.addIfNotNull(xml, "AdjDarMethod", request.getTransConfig().getAdjDarMethod());
            RequestXmlFactory.addIfNotNull(xml, "AudioBitrateAdjMethod", request.getTransConfig().getAudioBitrateAdjMethod());
            RequestXmlFactory.addIfNotNull(xml, "IsCheckAudioBitrate", request.getTransConfig().getIsCheckAudioBitrate());
            RequestXmlFactory.addIfNotNull(xml, "IsCheckReso", request.getTransConfig().getIsCheckReso());
            RequestXmlFactory.addIfNotNull(xml, "IsCheckVideoBitrate", request.getTransConfig().getIsCheckVideoBitrate());
            RequestXmlFactory.addIfNotNull(xml, "ResoAdjMethod", request.getTransConfig().getResoAdjMethod());
            RequestXmlFactory.addIfNotNull(xml, "TransMode", request.getTransConfig().getTransMode());
            RequestXmlFactory.addIfNotNull(xml, "VideoBitrateAdjMethod", request.getTransConfig().getVideoBitrateAdjMethod());
            xml.end();
            RequestXmlFactory.addVideo(xml, request);
        }
        xml.end();
        return xml.getBytes();
    }

    private static void addAudio(XmlWriter xml, MediaAudioObject audio) {
        xml.start("Audio");
        RequestXmlFactory.addIfNotNull(xml, "Bitrate", audio.getBitrate());
        RequestXmlFactory.addIfNotNull(xml, "Channels", audio.getChannels());
        RequestXmlFactory.addIfNotNull(xml, "Codec", audio.getCodec());
        RequestXmlFactory.addIfNotNull(xml, "Profile", audio.getProfile());
        RequestXmlFactory.addIfNotNull(xml, "Remove", audio.getRemove());
        RequestXmlFactory.addIfNotNull(xml, "Samplerate", audio.getSamplerate());
        xml.end();
    }

    public static byte[] convertToXmlByteArray(MediaInfoRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Input");
        xml.start("Object").value(request.getInput().getObject()).end();
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(DocJobRequest request) {
        XmlWriter xml = new XmlWriter();
        DocJobObject docJobObject = request.getDocJobObject();
        xml.start("Request");
        xml.start("Tag").value(docJobObject.getTag()).end();
        xml.start("QueueId").value(docJobObject.getQueueId()).end();
        xml.start("Input");
        xml.start("Object").value(docJobObject.getInput().getObject()).end();
        xml.end();
        if (CheckObjectUtils.objIsNotValid(docJobObject).booleanValue()) {
            xml.start("Operation");
            xml.start("Output");
            MediaOutputObject output = docJobObject.getOperation().getOutput();
            RequestXmlFactory.addIfNotNull(xml, "Region", output.getRegion());
            RequestXmlFactory.addIfNotNull(xml, "Bucket", output.getBucket());
            RequestXmlFactory.addIfNotNull(xml, "Object", output.getObject());
            xml.end();
            xml.start("DocProcess");
            DocProcessObject docProcess = docJobObject.getOperation().getDocProcessObject();
            RequestXmlFactory.addIfNotNull(xml, "SrcType", docProcess.getSrcType());
            RequestXmlFactory.addIfNotNull(xml, "TgtType", docProcess.getTgtType());
            RequestXmlFactory.addIfNotNull(xml, "SheetId", docProcess.getSheetId());
            RequestXmlFactory.addIfNotNull(xml, "StartPage", docProcess.getStartPage());
            RequestXmlFactory.addIfNotNull(xml, "EndPage", docProcess.getEndPage());
            RequestXmlFactory.addIfNotNull(xml, "ImageParams", docProcess.getImageParams());
            RequestXmlFactory.addIfNotNull(xml, "DocPassword", docProcess.getDocPassword());
            RequestXmlFactory.addIfNotNull(xml, "Comments", docProcess.getComments());
            RequestXmlFactory.addIfNotNull(xml, "PaperDirection", docProcess.getPaperDirection());
            RequestXmlFactory.addIfNotNull(xml, "Quality", docProcess.getQuality());
            RequestXmlFactory.addIfNotNull(xml, "Zoom", docProcess.getZoom());
            xml.end();
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(DocQueueRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Name").value(request.getName()).end();
        xml.start("QueueId").value(request.getQueueId()).end();
        xml.start("State").value(request.getState()).end();
        xml.start("NotifyConfig");
        RequestXmlFactory.addIfNotNull(xml, "Type", request.getNotifyConfig().getType());
        RequestXmlFactory.addIfNotNull(xml, "Url", request.getNotifyConfig().getUrl());
        RequestXmlFactory.addIfNotNull(xml, "Event", request.getNotifyConfig().getEvent());
        RequestXmlFactory.addIfNotNull(xml, "State", request.getNotifyConfig().getState());
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(VideoAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Input");
        RequestXmlFactory.addIfNotNull(xml, "Object", request.getInput().getObject());
        xml.end();
        Conf conf = request.getConf();
        xml.start("Conf");
        RequestXmlFactory.addIfNotNull(xml, "DetectType", conf.getDetectType());
        RequestXmlFactory.addIfNotNull(xml, "BizType", conf.getBizType());
        RequestXmlFactory.addIfNotNull(xml, "DetectContent", conf.getDetectContent());
        xml.start("Snapshot");
        RequestXmlFactory.addIfNotNull(xml, "Mode", conf.getSnapshot().getMode());
        RequestXmlFactory.addIfNotNull(xml, "TimeInterval", conf.getSnapshot().getTimeInterval());
        RequestXmlFactory.addIfNotNull(xml, "Count", conf.getSnapshot().getCount());
        xml.end();
        RequestXmlFactory.addIfNotNull(xml, "Callback", conf.getCallback());
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(AudioAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Input");
        RequestXmlFactory.addIfNotNull(xml, "Object", request.getInput().getObject());
        xml.end();
        Conf conf = request.getConf();
        xml.start("Conf");
        RequestXmlFactory.addIfNotNull(xml, "DetectType", conf.getDetectType());
        RequestXmlFactory.addIfNotNull(xml, "Callback", conf.getCallback());
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(TextAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Input");
        RequestXmlFactory.addIfNotNull(xml, "Object", request.getInput().getObject());
        xml.end();
        Conf conf = request.getConf();
        xml.start("Conf");
        RequestXmlFactory.addIfNotNull(xml, "DetectType", conf.getDetectType());
        RequestXmlFactory.addIfNotNull(xml, "Callback", conf.getCallback());
        RequestXmlFactory.addIfNotNull(xml, "BizType", conf.getBizType());
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    private static void addIfNotNull(XmlWriter xml, String xmlTag, String value) {
        if (value != null) {
            xml.start(xmlTag).value(value).end();
        }
    }

    private static void addIfNotNull(XmlWriter xml, String xmlTag, Object value) {
        if (value != null && value.toString() != null) {
            xml.start(xmlTag).value(value.toString()).end();
        }
    }

    private static void addVideo(XmlWriter xml, MediaTemplateRequest request) {
        MediaVideoObject video = request.getVideo();
        RequestXmlFactory.addVideo(xml, video);
    }

    private static void addVideo(XmlWriter xml, MediaVideoObject video) {
        if (CheckObjectUtils.objIsValid(video).booleanValue()) {
            return;
        }
        xml.start("Video");
        RequestXmlFactory.addIfNotNull(xml, "Codec", video.getCodec());
        RequestXmlFactory.addIfNotNull(xml, "Width", video.getWidth());
        RequestXmlFactory.addIfNotNull(xml, "Height", video.getHeight());
        RequestXmlFactory.addIfNotNull(xml, "Fps", video.getFps());
        RequestXmlFactory.addIfNotNull(xml, "Bitrate", video.getBitrate());
        RequestXmlFactory.addIfNotNull(xml, "BufSize", video.getBufSize());
        RequestXmlFactory.addIfNotNull(xml, "Crf", video.getCrf());
        RequestXmlFactory.addIfNotNull(xml, "Crop", video.getCrop());
        RequestXmlFactory.addIfNotNull(xml, "Gop", video.getGop());
        RequestXmlFactory.addIfNotNull(xml, "LongShortMode", video.getLongShortMode());
        RequestXmlFactory.addIfNotNull(xml, "Maxrate", video.getMaxrate());
        RequestXmlFactory.addIfNotNull(xml, "Pad", video.getPad());
        RequestXmlFactory.addIfNotNull(xml, "PixFmt", video.getPixFmt());
        RequestXmlFactory.addIfNotNull(xml, "Preset", video.getPreset());
        RequestXmlFactory.addIfNotNull(xml, "Profile", video.getProfile());
        RequestXmlFactory.addIfNotNull(xml, "Qality", video.getQality());
        RequestXmlFactory.addIfNotNull(xml, "Quality", video.getQuality());
        RequestXmlFactory.addIfNotNull(xml, "Remove", video.getRemove());
        RequestXmlFactory.addIfNotNull(xml, "ScanMode", video.getScanMode());
        RequestXmlFactory.addIfNotNull(xml, "HlsTsTime", video.getHlsTsTime());
        RequestXmlFactory.addIfNotNull(xml, "AnimateFramesPerSecond", video.getAnimateFramesPerSecond());
        RequestXmlFactory.addIfNotNull(xml, "AnimateTimeIntervalOfFrame", video.getAnimateTimeIntervalOfFrame());
        RequestXmlFactory.addIfNotNull(xml, "AnimateOnlyKeepKeyFrame", video.getAnimateOnlyKeepKeyFrame());
        xml.end();
    }

    private static void addVideo(XmlWriter xml, MediaTranscodeVideoObject video) {
        if (CheckObjectUtils.objIsValid(video).booleanValue()) {
            return;
        }
        xml.start("Video");
        RequestXmlFactory.addIfNotNull(xml, "Codec", video.getCodec());
        RequestXmlFactory.addIfNotNull(xml, "Width", video.getWidth());
        RequestXmlFactory.addIfNotNull(xml, "Height", video.getHeight());
        RequestXmlFactory.addIfNotNull(xml, "Fps", video.getFps());
        RequestXmlFactory.addIfNotNull(xml, "Bitrate", video.getBitrate());
        RequestXmlFactory.addIfNotNull(xml, "BufSize", video.getBufSize());
        RequestXmlFactory.addIfNotNull(xml, "Crf", video.getCrf());
        RequestXmlFactory.addIfNotNull(xml, "Gop", video.getGop());
        RequestXmlFactory.addIfNotNull(xml, "Maxrate", video.getMaxrate());
        RequestXmlFactory.addIfNotNull(xml, "Preset", video.getPreset());
        RequestXmlFactory.addIfNotNull(xml, "Profile", video.getProfile());
        RequestXmlFactory.addIfNotNull(xml, "Remove", video.getRemove());
        RequestXmlFactory.addIfNotNull(xml, "ScanMode", video.getScanMode());
        xml.end();
    }

    private static class CheckObjectUtils {
        private CheckObjectUtils() {
        }

        public static Boolean objIsNotValid(Object obj) {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object o = field.get(obj);
                    if (CheckObjectUtils.isValid(o)) continue;
                    return true;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public static Boolean objIsValid(Object obj) {
            return CheckObjectUtils.objIsNotValid(obj) == false;
        }

        public static boolean isValid(Object obj) {
            return obj == null || CheckObjectUtils.isValid(obj.toString());
        }

        public static boolean isValid(String str) {
            return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
        }
    }
}

