/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.models.dto.auth;

import com.qaprosoft.zafira.models.db.Group;
import com.qaprosoft.zafira.models.dto.auth.UserGrantedAuthority;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtUserType
implements UserDetails {
    private static final long serialVersionUID = 2105145272583220476L;
    private long id;
    private String username;
    private String password;
    private List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();

    public JwtUserType(long id, String username, List<Group> groups) {
        this.id = id;
        this.username = username;
        this.authorities = groups.stream().map(group -> new UserGrantedAuthority(group.getRole().name(), group.getPermissionNames())).collect(Collectors.toList());
        if (this.authorities.isEmpty()) {
            this.authorities.add(new UserGrantedAuthority("ROLE_USER", new HashSet<String>()));
        }
    }

    public JwtUserType(long id, String username, String password, List<Group> groups) {
        this(id, username, groups);
        this.password = password;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

