/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;

@FileStatefulCheck
public final class NPathComplexityCheck
extends AbstractCheck {
    public static final String MSG_KEY = "npathComplexity";
    private static final int DEFAULT_MAX = 200;
    private static final BigInteger INITIAL_VALUE = BigInteger.ZERO;
    private final Deque<BigInteger> rangeValues = new ArrayDeque<BigInteger>();
    private final Deque<Integer> expressionValues = new ArrayDeque<Integer>();
    private final Deque<Boolean> afterValues = new ArrayDeque<Boolean>();
    private final TokenEnd processingTokenEnd = new TokenEnd();
    private BigInteger currentRangeValue = INITIAL_VALUE;
    private int max = 200;
    private boolean branchVisited;

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{8, 9, 12, 11, 84, 85, 91, 83, 92, 89, 33, 95, 96, 109, 88, 94, 203, 208};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.rangeValues.clear();
        this.expressionValues.clear();
        this.afterValues.clear();
        this.processingTokenEnd.reset();
        this.currentRangeValue = INITIAL_VALUE;
        this.branchVisited = false;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 91: {
                this.visitConditional(ast, 1);
                break;
            }
            case 109: {
                this.visitUnitaryOperator(ast, 2);
                break;
            }
            case 88: {
                this.visitUnitaryOperator(ast, 0);
                break;
            }
            case 33: {
                int caseNumber = NPathComplexityCheck.countCaseTokens(ast);
                this.branchVisited = true;
                this.pushValue(caseNumber);
                break;
            }
            case 208: {
                int caseConstantNumber = NPathComplexityCheck.countCaseConstants(ast);
                this.branchVisited = true;
                this.pushValue(caseConstantNumber);
                break;
            }
            case 92: {
                this.branchVisited = true;
                if (this.currentRangeValue.equals(BigInteger.ZERO)) {
                    this.currentRangeValue = BigInteger.ONE;
                }
                this.pushValue(0);
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                this.pushValue(1);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 203: {
                this.pushValue(0);
                break;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 91: {
                this.leaveConditional();
                break;
            }
            case 95: {
                this.leaveMultiplyingConditional();
                break;
            }
            case 88: 
            case 109: {
                this.leaveUnitaryOperator();
                break;
            }
            case 96: {
                this.leaveAddingConditional();
                break;
            }
            case 94: {
                this.leaveBranch();
                break;
            }
            case 33: 
            case 92: 
            case 208: {
                this.leaveBranch();
                this.branchVisited = false;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 203: {
                this.leaveMethodDef(ast);
                break;
            }
        }
    }

    private void visitConditional(DetailAST ast, int basicBranchingFactor) {
        int expressionValue = basicBranchingFactor;
        DetailAST bracketed = ast.findFirstToken(76).getNextSibling();
        while (bracketed.getType() != 77) {
            expressionValue += NPathComplexityCheck.countConditionalOperators(bracketed);
            bracketed = bracketed.getNextSibling();
        }
        this.processingTokenEnd.setToken(bracketed);
        this.pushValue(expressionValue);
    }

    private void visitUnitaryOperator(DetailAST ast, int basicBranchingFactor) {
        boolean isAfter = this.processingTokenEnd.isAfter(ast);
        this.afterValues.push(isAfter);
        if (!isAfter) {
            this.processingTokenEnd.setToken(NPathComplexityCheck.getLastToken(ast));
            int expressionValue = basicBranchingFactor + NPathComplexityCheck.countConditionalOperators(ast);
            this.pushValue(expressionValue);
        }
    }

    private void leaveUnitaryOperator() {
        if (Boolean.FALSE.equals(this.afterValues.pop())) {
            Values valuePair = this.popValue();
            BigInteger basicRangeValue = valuePair.getRangeValue();
            BigInteger expressionValue = valuePair.getExpressionValue();
            if (expressionValue.equals(BigInteger.ZERO)) {
                expressionValue = BigInteger.ONE;
            }
            if (basicRangeValue.equals(BigInteger.ZERO)) {
                basicRangeValue = BigInteger.ONE;
            }
            this.currentRangeValue = this.currentRangeValue.add(expressionValue).multiply(basicRangeValue);
        }
    }

    private void leaveConditional() {
        Values valuePair = this.popValue();
        BigInteger expressionValue = valuePair.getExpressionValue();
        BigInteger basicRangeValue = valuePair.getRangeValue();
        if (this.currentRangeValue.equals(BigInteger.ZERO)) {
            this.currentRangeValue = BigInteger.ONE;
        }
        if (basicRangeValue.equals(BigInteger.ZERO)) {
            basicRangeValue = BigInteger.ONE;
        }
        this.currentRangeValue = this.currentRangeValue.add(expressionValue).multiply(basicRangeValue);
    }

    private void leaveBranch() {
        Values valuePair = this.popValue();
        BigInteger basicRangeValue = valuePair.getRangeValue();
        BigInteger expressionValue = valuePair.getExpressionValue();
        if (this.branchVisited && this.currentRangeValue.equals(BigInteger.ZERO)) {
            this.currentRangeValue = BigInteger.ONE;
        }
        this.currentRangeValue = this.currentRangeValue.subtract(BigInteger.ONE).add(basicRangeValue).add(expressionValue);
    }

    private void leaveMethodDef(DetailAST ast) {
        BigInteger bigIntegerMax = BigInteger.valueOf(this.max);
        if (this.currentRangeValue.compareTo(bigIntegerMax) > 0) {
            this.log(ast, MSG_KEY, this.currentRangeValue, bigIntegerMax);
        }
        this.popValue();
        this.currentRangeValue = INITIAL_VALUE;
    }

    private void leaveAddingConditional() {
        this.currentRangeValue = this.currentRangeValue.add(this.popValue().getRangeValue().add(BigInteger.ONE));
    }

    private void pushValue(Integer expressionValue) {
        this.rangeValues.push(this.currentRangeValue);
        this.expressionValues.push(expressionValue);
        this.currentRangeValue = INITIAL_VALUE;
    }

    private Values popValue() {
        int expressionValue = this.expressionValues.pop();
        return new Values(this.rangeValues.pop(), BigInteger.valueOf(expressionValue));
    }

    private void leaveMultiplyingConditional() {
        this.currentRangeValue = this.currentRangeValue.add(BigInteger.ONE).multiply(this.popValue().getRangeValue().add(BigInteger.ONE));
    }

    private static int countConditionalOperators(DetailAST ast) {
        int number = 0;
        for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            int type = child.getType();
            if (type == 110 || type == 111) {
                ++number;
            } else if (type == 109) {
                number += 2;
            }
            number += NPathComplexityCheck.countConditionalOperators(child);
        }
        return number;
    }

    private static DetailAST getLastToken(DetailAST ast) {
        DetailAST lastChild = ast.getLastChild();
        DetailAST result = lastChild.getFirstChild() == null ? lastChild : NPathComplexityCheck.getLastToken(lastChild);
        return result;
    }

    private static int countCaseTokens(DetailAST ast) {
        int counter = 0;
        for (DetailAST iterator = ast.getFirstChild(); iterator != null; iterator = iterator.getNextSibling()) {
            if (iterator.getType() != 93) continue;
            ++counter;
        }
        return counter;
    }

    private static int countCaseConstants(DetailAST ast) {
        AtomicInteger counter = new AtomicInteger();
        DetailAST literalCase = ast.getFirstChild();
        TokenUtil.forEachChild(literalCase, 28, node -> counter.getAndIncrement());
        return counter.get();
    }

    private static class Values {
        private final BigInteger rangeValue;
        private final BigInteger expressionValue;

        Values(BigInteger valueOfRange, BigInteger valueOfExpression) {
            this.rangeValue = valueOfRange;
            this.expressionValue = valueOfExpression;
        }

        public BigInteger getRangeValue() {
            return this.rangeValue;
        }

        public BigInteger getExpressionValue() {
            return this.expressionValue;
        }
    }

    private static class TokenEnd {
        private int endLineNo;
        private int endColumnNo;

        private TokenEnd() {
        }

        public void setToken(DetailAST endToken) {
            if (!this.isAfter(endToken)) {
                this.endLineNo = endToken.getLineNo();
                this.endColumnNo = endToken.getColumnNo();
            }
        }

        public void reset() {
            this.endLineNo = 0;
            this.endColumnNo = 0;
        }

        public boolean isAfter(DetailAST ast) {
            int lineNo = ast.getLineNo();
            int columnNo = ast.getColumnNo();
            boolean isAfter = true;
            if (lineNo > this.endLineNo || lineNo == this.endLineNo && columnNo > this.endColumnNo) {
                isAfter = false;
            }
            return isAfter;
        }
    }
}

