/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.workers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.DuplicationManager;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.files.PNDownloadableFile;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.models.consumer.objects_api.channel.PNChannelMetadata;
import com.pubnub.api.models.consumer.objects_api.channel.PNChannelMetadataResult;
import com.pubnub.api.models.consumer.objects_api.membership.PNMembership;
import com.pubnub.api.models.consumer.objects_api.membership.PNMembershipResult;
import com.pubnub.api.models.consumer.objects_api.uuid.PNUUIDMetadata;
import com.pubnub.api.models.consumer.objects_api.uuid.PNUUIDMetadataResult;
import com.pubnub.api.models.consumer.pubsub.BasePubSubResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.ObjectPayload;
import com.pubnub.api.models.server.PresenceEnvelope;
import com.pubnub.api.models.server.PublishMetaData;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.models.server.files.FileUploadNotification;
import com.pubnub.api.vendor.Crypto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeMessageWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SubscribeMessageWorker.class);
    public static final int TYPE_MESSAGE = 0;
    private final int typeSignal = 1;
    private final int typeObject = 2;
    private final int typeMessageAction = 3;
    public static final int TYPE_FILES = 4;
    private PubNub pubnub;
    private ListenerManager listenerManager;
    private LinkedBlockingQueue<SubscribeMessage> queue;
    private DuplicationManager duplicationManager;
    private final String formatFriendlyGetFileUrl = "%s" + "/v1/files/{subKey}/channels/{channel}/files/{fileId}/{fileName}".replaceAll("\\{.*?\\}", "%s");

    public SubscribeMessageWorker(PubNub pubnubInstance, ListenerManager listenerManagerInstance, LinkedBlockingQueue<SubscribeMessage> queueInstance, DuplicationManager dupManager) {
        this.pubnub = pubnubInstance;
        this.listenerManager = listenerManagerInstance;
        this.queue = queueInstance;
        this.duplicationManager = dupManager;
    }

    @Override
    public void run() {
        this.takeMessage();
    }

    private void takeMessage() {
        while (!Thread.interrupted()) {
            try {
                this.processIncomingPayload(this.queue.take());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.trace("take message interrupted", (Throwable)e);
            }
        }
    }

    private JsonElement processMessage(SubscribeMessage subscribeMessage) {
        JsonElement outputObject;
        String outputText;
        JsonElement input = subscribeMessage.getPayload();
        if (this.pubnub.getConfiguration().getCipherKey() == null) {
            return input;
        }
        if (!subscribeMessage.supportsEncryption()) {
            return input;
        }
        Crypto crypto = new Crypto(this.pubnub.getConfiguration().getCipherKey(), this.pubnub.getConfiguration().isUseRandomInitializationVector());
        MapperManager mapper = this.pubnub.getMapper();
        String inputText = mapper.isJsonObject(input) && mapper.hasField(input, "pn_other") ? mapper.elementToString(input, "pn_other") : mapper.elementToString(input);
        try {
            outputText = crypto.decrypt(inputText);
        }
        catch (PubNubException e) {
            PNStatus pnStatus = PNStatus.builder().error(true).errorData(new PNErrorData(e.getMessage(), e)).operation(PNOperationType.PNSubscribeOperation).category(PNStatusCategory.PNDecryptionErrorCategory).build();
            this.listenerManager.announce(pnStatus);
            return null;
        }
        try {
            outputObject = mapper.fromJson(outputText, JsonElement.class);
        }
        catch (PubNubException e) {
            PNStatus pnStatus = PNStatus.builder().error(true).errorData(new PNErrorData(e.getMessage(), e)).operation(PNOperationType.PNSubscribeOperation).category(PNStatusCategory.PNMalformedResponseCategory).build();
            this.listenerManager.announce(pnStatus);
            return null;
        }
        if (mapper.isJsonObject(input) && mapper.hasField(input, "pn_other")) {
            JsonObject objectNode = mapper.getAsObject(input);
            mapper.putOnObject(objectNode, "pn_other", outputObject);
            outputObject = objectNode;
        }
        return outputObject;
    }

    private void processIncomingPayload(SubscribeMessage message) {
        MapperManager mapper = this.pubnub.getMapper();
        String channel = message.getChannel();
        String subscriptionMatch = message.getSubscriptionMatch();
        PublishMetaData publishMetaData = message.getPublishMetaData();
        if (channel != null && channel.equals(subscriptionMatch)) {
            subscriptionMatch = null;
        }
        if (this.pubnub.getConfiguration().isDedupOnSubscribe()) {
            if (this.duplicationManager.isDuplicate(message)) {
                return;
            }
            this.duplicationManager.addEntry(message);
        }
        if (message.getChannel().endsWith("-pnpres")) {
            PresenceEnvelope presencePayload = (PresenceEnvelope)mapper.convertValue(message.getPayload(), PresenceEnvelope.class);
            String strippedPresenceChannel = null;
            String strippedPresenceSubscription = null;
            if (channel != null) {
                strippedPresenceChannel = PubNubUtil.replaceLast(channel, "-pnpres", "");
            }
            if (subscriptionMatch != null) {
                strippedPresenceSubscription = PubNubUtil.replaceLast(subscriptionMatch, "-pnpres", "");
            }
            JsonElement isHereNowRefresh = message.getPayload().getAsJsonObject().get("here_now_refresh");
            PNPresenceEventResult pnPresenceEventResult = PNPresenceEventResult.builder().event(presencePayload.getAction()).actualChannel(subscriptionMatch != null ? channel : null).subscribedChannel(subscriptionMatch != null ? subscriptionMatch : channel).channel(strippedPresenceChannel).subscription(strippedPresenceSubscription).state(presencePayload.getData()).timetoken(publishMetaData.getPublishTimetoken()).occupancy(presencePayload.getOccupancy()).uuid(presencePayload.getUuid()).timestamp(presencePayload.getTimestamp()).join(this.getDelta(message.getPayload().getAsJsonObject().get("join"))).leave(this.getDelta(message.getPayload().getAsJsonObject().get("leave"))).timeout(this.getDelta(message.getPayload().getAsJsonObject().get("timeout"))).hereNowRefresh(isHereNowRefresh != null && isHereNowRefresh.getAsBoolean()).build();
            this.listenerManager.announce(pnPresenceEventResult);
        } else {
            JsonElement extractedMessage = this.processMessage(message);
            if (extractedMessage == null) {
                log.debug("unable to parse payload on #processIncomingMessages");
            }
            BasePubSubResult result = BasePubSubResult.builder().actualChannel(subscriptionMatch != null ? channel : null).subscribedChannel(subscriptionMatch != null ? subscriptionMatch : channel).channel(channel).subscription(subscriptionMatch).timetoken(publishMetaData.getPublishTimetoken()).publisher(message.getIssuingClientId()).userMetadata(message.getUserMetadata()).build();
            if (message.getType() == null) {
                this.listenerManager.announce(new PNMessageResult(result, extractedMessage));
            } else if (message.getType() == 0) {
                this.listenerManager.announce(new PNMessageResult(result, extractedMessage));
            } else if (message.getType() == 1) {
                this.listenerManager.announce(new PNSignalResult(result, extractedMessage));
            } else if (message.getType() == 2) {
                ObjectPayload objectPayload = (ObjectPayload)mapper.convertValue(extractedMessage, ObjectPayload.class);
                String type = objectPayload.getType();
                if (this.canHandleObjectCallback(objectPayload)) {
                    switch (type) {
                        case "channel": {
                            PNChannelMetadataResult channelMetadataResult = new PNChannelMetadataResult(result, objectPayload.getEvent(), (PNChannelMetadata)mapper.convertValue(objectPayload.getData(), PNChannelMetadata.class));
                            this.listenerManager.announce(channelMetadataResult);
                            break;
                        }
                        case "membership": {
                            PNMembershipResult membershipResult = new PNMembershipResult(result, objectPayload.getEvent(), (PNMembership)mapper.convertValue(objectPayload.getData(), PNMembership.class));
                            this.listenerManager.announce(membershipResult);
                            break;
                        }
                        case "uuid": {
                            PNUUIDMetadataResult uuidMetadataResult = new PNUUIDMetadataResult(result, objectPayload.getEvent(), (PNUUIDMetadata)mapper.convertValue(objectPayload.getData(), PNUUIDMetadata.class));
                            this.listenerManager.announce(uuidMetadataResult);
                            break;
                        }
                    }
                }
            } else if (message.getType() == 3) {
                ObjectPayload objectPayload = (ObjectPayload)mapper.convertValue(extractedMessage, ObjectPayload.class);
                JsonObject data = objectPayload.getData().getAsJsonObject();
                if (!data.has("uuid")) {
                    data.addProperty("uuid", result.getPublisher());
                }
                this.listenerManager.announce(PNMessageActionResult.actionBuilder().result(result).event(objectPayload.getEvent()).data((PNMessageAction)mapper.convertValue((JsonElement)data, PNMessageAction.class)).build());
            } else if (message.getType() == 4) {
                FileUploadNotification event = (FileUploadNotification)mapper.convertValue(extractedMessage, FileUploadNotification.class);
                this.listenerManager.announce(PNFileEventResult.builder().file(new PNDownloadableFile(event.getFile().getId(), event.getFile().getName(), this.buildFileUrl(message.getChannel(), event.getFile().getId(), event.getFile().getName()))).message(event.getMessage()).channel(message.getChannel()).publisher(message.getIssuingClientId()).timetoken(publishMetaData.getPublishTimetoken()).build());
            }
        }
    }

    private String buildFileUrl(String channel, String fileId, String fileName) {
        String basePath = String.format(this.formatFriendlyGetFileUrl, this.pubnub.getBaseUrl(), this.pubnub.getConfiguration().getSubscribeKey(), channel, fileId, fileName);
        ArrayList<String> queryParams = new ArrayList<String>();
        String authKey = this.pubnub.getConfiguration().getAuthKey();
        if (PubNubUtil.shouldSignRequest(this.pubnub.getConfiguration())) {
            int timestamp = this.pubnub.getTimestamp();
            String signature = this.generateSignature(this.pubnub.getConfiguration(), basePath, authKey, timestamp);
            queryParams.add("timestamp=" + timestamp);
            queryParams.add("signature=" + signature);
        }
        if (authKey != null) {
            queryParams.add("auth=" + authKey);
        }
        if (queryParams.isEmpty()) {
            return basePath;
        }
        return basePath + "?" + PubNubUtil.joinString(queryParams, "&");
    }

    private String generateSignature(PNConfiguration configuration, String url, String authKey, int timestamp) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (authKey != null) {
            queryParams.put("auth", authKey);
        }
        return PubNubUtil.generateSignature(configuration, url, queryParams, "get", null, timestamp);
    }

    private boolean canHandleObjectCallback(ObjectPayload objectPayload) {
        return objectPayload.getVersion().equals("2.0");
    }

    private List<String> getDelta(JsonElement delta) {
        ArrayList<String> list = new ArrayList<String>();
        if (delta != null) {
            JsonArray jsonArray = delta.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(jsonArray.get(i).getAsString());
            }
        }
        return list;
    }
}

