/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.server.access_manager.v3;

import com.pubnub.api.PubNubException;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.api.models.consumer.access_manager.v3.PNResource;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GrantTokenRequestBody {
    private final Integer ttl;
    private final GrantTokenPermissions permissions;

    public static GrantTokenRequestBody of(Integer ttl, List<ChannelGrant> channels, List<ChannelGroupGrant> groups, List<UUIDGrant> uuids, Object meta, String uuid) throws PubNubException {
        GrantTokenPermission resources = new GrantTokenPermission(GrantTokenRequestBody.getResources(channels), GrantTokenRequestBody.getResources(groups), GrantTokenRequestBody.getResources(uuids));
        GrantTokenPermission patterns = new GrantTokenPermission(GrantTokenRequestBody.getPatterns(channels), GrantTokenRequestBody.getPatterns(groups), GrantTokenRequestBody.getPatterns(uuids));
        GrantTokenPermissions permissions = new GrantTokenPermissions(resources, patterns, meta == null ? Collections.emptyMap() : meta, uuid);
        return new GrantTokenRequestBody(ttl, permissions);
    }

    private static <T extends PNResource<?>> Map<String, Integer> getResources(List<T> resources) throws PubNubException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (PNResource resource : resources) {
            if (resource.isPatternResource()) continue;
            result.put(resource.getId(), GrantTokenRequestBody.calculateBitmask(resource));
        }
        return result;
    }

    private static <T extends PNResource<?>> Map<String, Integer> getPatterns(List<T> resources) throws PubNubException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (PNResource resource : resources) {
            if (!resource.isPatternResource()) continue;
            result.put(resource.getId(), GrantTokenRequestBody.calculateBitmask(resource));
        }
        return result;
    }

    private static int calculateBitmask(PNResource<?> resource) throws PubNubException {
        int sum = 0;
        if (resource.isRead()) {
            sum |= 1;
        }
        if (resource.isWrite()) {
            sum |= 2;
        }
        if (resource.isManage()) {
            sum |= 4;
        }
        if (resource.isDelete()) {
            sum |= 8;
        }
        if (resource.isCreate()) {
            sum |= 0x10;
        }
        if (resource.isGet()) {
            sum |= 0x20;
        }
        if (resource.isJoin()) {
            sum |= 0x80;
        }
        if (resource.isUpdate()) {
            sum |= 0x40;
        }
        return sum;
    }

    public static GrantTokenRequestBodyBuilder builder() {
        return new GrantTokenRequestBodyBuilder();
    }

    public GrantTokenRequestBody(Integer ttl, GrantTokenPermissions permissions) {
        this.ttl = ttl;
        this.permissions = permissions;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public GrantTokenPermissions getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrantTokenRequestBody)) {
            return false;
        }
        GrantTokenRequestBody other = (GrantTokenRequestBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        GrantTokenPermissions this$permissions = this.getPermissions();
        GrantTokenPermissions other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrantTokenRequestBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        GrantTokenPermissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    public String toString() {
        return "GrantTokenRequestBody(ttl=" + this.getTtl() + ", permissions=" + this.getPermissions() + ")";
    }

    public static class GrantTokenRequestBodyBuilder {
        private Integer ttl;
        private List<ChannelGrant> channels;
        private List<ChannelGroupGrant> groups;
        private List<UUIDGrant> uuids;
        private Object meta;
        private String uuid;

        GrantTokenRequestBodyBuilder() {
        }

        public GrantTokenRequestBodyBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public GrantTokenRequestBodyBuilder channels(List<ChannelGrant> channels) {
            this.channels = channels;
            return this;
        }

        public GrantTokenRequestBodyBuilder groups(List<ChannelGroupGrant> groups) {
            this.groups = groups;
            return this;
        }

        public GrantTokenRequestBodyBuilder uuids(List<UUIDGrant> uuids) {
            this.uuids = uuids;
            return this;
        }

        public GrantTokenRequestBodyBuilder meta(Object meta) {
            this.meta = meta;
            return this;
        }

        public GrantTokenRequestBodyBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public GrantTokenRequestBody build() throws PubNubException {
            return GrantTokenRequestBody.of(this.ttl, this.channels, this.groups, this.uuids, this.meta, this.uuid);
        }

        public String toString() {
            return "GrantTokenRequestBody.GrantTokenRequestBodyBuilder(ttl=" + this.ttl + ", channels=" + this.channels + ", groups=" + this.groups + ", uuids=" + this.uuids + ", meta=" + this.meta + ", uuid=" + this.uuid + ")";
        }
    }

    public static class GrantTokenPermission {
        private final Map<String, Integer> channels;
        private final Map<String, Integer> groups;
        private final Map<String, Integer> uuids;
        private final Map<String, Integer> spaces = Collections.emptyMap();
        private final Map<String, Integer> users = Collections.emptyMap();

        public GrantTokenPermission(Map<String, Integer> channels, Map<String, Integer> groups, Map<String, Integer> uuids) {
            this.channels = channels;
            this.groups = groups;
            this.uuids = uuids;
        }

        public Map<String, Integer> getChannels() {
            return this.channels;
        }

        public Map<String, Integer> getGroups() {
            return this.groups;
        }

        public Map<String, Integer> getUuids() {
            return this.uuids;
        }

        public Map<String, Integer> getSpaces() {
            return this.spaces;
        }

        public Map<String, Integer> getUsers() {
            return this.users;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GrantTokenPermission)) {
                return false;
            }
            GrantTokenPermission other = (GrantTokenPermission)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Integer> this$channels = this.getChannels();
            Map<String, Integer> other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
                return false;
            }
            Map<String, Integer> this$groups = this.getGroups();
            Map<String, Integer> other$groups = other.getGroups();
            if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
                return false;
            }
            Map<String, Integer> this$uuids = this.getUuids();
            Map<String, Integer> other$uuids = other.getUuids();
            if (this$uuids == null ? other$uuids != null : !((Object)this$uuids).equals(other$uuids)) {
                return false;
            }
            Map<String, Integer> this$spaces = this.getSpaces();
            Map<String, Integer> other$spaces = other.getSpaces();
            if (this$spaces == null ? other$spaces != null : !((Object)this$spaces).equals(other$spaces)) {
                return false;
            }
            Map<String, Integer> this$users = this.getUsers();
            Map<String, Integer> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GrantTokenPermission;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Integer> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            Map<String, Integer> $groups = this.getGroups();
            result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
            Map<String, Integer> $uuids = this.getUuids();
            result = result * 59 + ($uuids == null ? 43 : ((Object)$uuids).hashCode());
            Map<String, Integer> $spaces = this.getSpaces();
            result = result * 59 + ($spaces == null ? 43 : ((Object)$spaces).hashCode());
            Map<String, Integer> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        public String toString() {
            return "GrantTokenRequestBody.GrantTokenPermission(channels=" + this.getChannels() + ", groups=" + this.getGroups() + ", uuids=" + this.getUuids() + ", spaces=" + this.getSpaces() + ", users=" + this.getUsers() + ")";
        }
    }

    private static class GrantTokenPermissions {
        private final GrantTokenPermission resources;
        private final GrantTokenPermission patterns;
        private final Object meta;
        private final String uuid;

        public GrantTokenPermissions(GrantTokenPermission resources, GrantTokenPermission patterns, Object meta, String uuid) {
            this.resources = resources;
            this.patterns = patterns;
            this.meta = meta;
            this.uuid = uuid;
        }

        public GrantTokenPermission getResources() {
            return this.resources;
        }

        public GrantTokenPermission getPatterns() {
            return this.patterns;
        }

        public Object getMeta() {
            return this.meta;
        }

        public String getUuid() {
            return this.uuid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GrantTokenPermissions)) {
                return false;
            }
            GrantTokenPermissions other = (GrantTokenPermissions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GrantTokenPermission this$resources = this.getResources();
            GrantTokenPermission other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            GrantTokenPermission this$patterns = this.getPatterns();
            GrantTokenPermission other$patterns = other.getPatterns();
            if (this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns)) {
                return false;
            }
            Object this$meta = this.getMeta();
            Object other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !this$meta.equals(other$meta)) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            return !(this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GrantTokenPermissions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GrantTokenPermission $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            GrantTokenPermission $patterns = this.getPatterns();
            result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
            Object $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            return result;
        }

        public String toString() {
            return "GrantTokenRequestBody.GrantTokenPermissions(resources=" + this.getResources() + ", patterns=" + this.getPatterns() + ", meta=" + this.getMeta() + ", uuid=" + this.getUuid() + ")";
        }
    }
}

