/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.memberships;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.objects_api.CompositeParameterEnricher;
import com.pubnub.api.endpoints.objects_api.memberships.ManageMemberships;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.ListCapabilities;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.objects_api.membership.PNChannelMembership;
import com.pubnub.api.models.consumer.objects_api.membership.PNManageMembershipResult;
import com.pubnub.api.models.consumer.objects_api.membership.PNMembership;
import com.pubnub.api.models.server.objects_api.EntityArrayEnvelope;
import com.pubnub.api.models.server.objects_api.PatchMembershipPayload;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

final class ManageMembershipsCommand
extends ManageMemberships
implements Include.HavingCustomInclude<ManageMemberships>,
Include.HavingChannelInclude<ManageMemberships>,
ListCapabilities.HavingListCapabilites<ManageMemberships> {
    private final Collection<PNChannelMembership> channelsToSet;
    private final Collection<PNChannelMembership> channelsToRemove;

    ManageMembershipsCommand(Collection<PNChannelMembership> channelsToSet, Collection<PNChannelMembership> channelsToRemove, PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, CompositeParameterEnricher compositeParameterEnricher, TokenManager tokenManager) {
        super(pubnubInstance, telemetry, retrofitInstance, compositeParameterEnricher, tokenManager);
        this.channelsToSet = channelsToSet;
        this.channelsToRemove = channelsToRemove;
    }

    @Override
    protected Call<EntityArrayEnvelope<PNMembership>> executeCommand(Map<String, String> effectiveParams) throws PubNubException {
        PatchMembershipPayload patchMembershipBody = new PatchMembershipPayload(this.channelsToSet != null ? this.channelsToSet : Collections.emptyList(), this.channelsToRemove != null ? this.channelsToRemove : Collections.emptyList());
        return this.getRetrofit().getUuidMetadataService().patchMembership(this.getPubnub().getConfiguration().getSubscribeKey(), this.effectiveUuid(), patchMembershipBody, effectiveParams);
    }

    @Override
    protected PNManageMembershipResult createResponse(Response<EntityArrayEnvelope<PNMembership>> input) throws PubNubException {
        if (input.body() != null) {
            return new PNManageMembershipResult((EntityArrayEnvelope)input.body());
        }
        return new PNManageMembershipResult();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNManageMembershipsOperation;
    }

    @Override
    public CompositeParameterEnricher getCompositeParameterEnricher() {
        return super.getCompositeParameterEnricher();
    }
}

