/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.members;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.objects_api.CompositeParameterEnricher;
import com.pubnub.api.endpoints.objects_api.members.SetChannelMembers;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.ListCapabilities;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.objects_api.member.PNMembers;
import com.pubnub.api.models.consumer.objects_api.member.PNSetChannelMembersResult;
import com.pubnub.api.models.consumer.objects_api.member.PNUUID;
import com.pubnub.api.models.server.objects_api.EntityArrayEnvelope;
import com.pubnub.api.models.server.objects_api.PatchMemberPayload;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

final class SetChannelMembersCommand
extends SetChannelMembers
implements Include.HavingCustomInclude<SetChannelMembers>,
Include.HavingUUIDInclude<SetChannelMembers>,
ListCapabilities.HavingListCapabilites<SetChannelMembers> {
    private final Collection<PNUUID> uuids;

    SetChannelMembersCommand(String channel, Collection<PNUUID> uuids, PubNub pubNub, TelemetryManager telemetryManager, RetrofitManager retrofitManager, CompositeParameterEnricher compositeParameterEnricher, TokenManager tokenManager) {
        super(channel, pubNub, telemetryManager, retrofitManager, compositeParameterEnricher, tokenManager);
        this.uuids = uuids;
    }

    @Override
    protected Call<EntityArrayEnvelope<PNMembers>> executeCommand(Map<String, String> effectiveParams) throws PubNubException {
        PatchMemberPayload patchMemberBody = new PatchMemberPayload(this.uuids, Collections.emptyList());
        return this.getRetrofit().getChannelMetadataService().patchMembers(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, patchMemberBody, effectiveParams);
    }

    @Override
    protected PNSetChannelMembersResult createResponse(Response<EntityArrayEnvelope<PNMembers>> input) throws PubNubException {
        if (input.body() != null) {
            return new PNSetChannelMembersResult((EntityArrayEnvelope)input.body());
        }
        return new PNSetChannelMembersResult();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNSetChannelMembersOperation;
    }

    @Override
    public CompositeParameterEnricher getCompositeParameterEnricher() {
        return super.getCompositeParameterEnricher();
    }
}

