/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api.channel;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.objects_api.CompositeParameterEnricher;
import com.pubnub.api.endpoints.objects_api.channel.SetChannelMetadata;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.objects_api.channel.PNChannelMetadata;
import com.pubnub.api.models.consumer.objects_api.channel.PNSetChannelMetadataResult;
import com.pubnub.api.models.server.objects_api.EntityEnvelope;
import com.pubnub.api.models.server.objects_api.SetChannelMetadataPayload;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

final class SetChannelMetadataCommand
extends SetChannelMetadata
implements Include.HavingCustomInclude<SetChannelMetadata> {
    private String name;
    private String description;
    private Object custom;

    SetChannelMetadataCommand(String channel, PubNub pubNub, TelemetryManager telemetryManager, RetrofitManager retrofitManager, CompositeParameterEnricher compositeParameterEnricher, TokenManager tokenManager) {
        super(channel, pubNub, telemetryManager, retrofitManager, compositeParameterEnricher, tokenManager);
    }

    @Override
    protected Call<EntityEnvelope<PNChannelMetadata>> executeCommand(Map<String, String> effectiveParams) throws PubNubException {
        SetChannelMetadataPayload setChannelMetadataPayload = new SetChannelMetadataPayload(this.name, this.description, this.custom);
        return this.getRetrofit().getChannelMetadataService().setChannelsMetadata(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, setChannelMetadataPayload, effectiveParams);
    }

    @Override
    protected PNSetChannelMetadataResult createResponse(Response<EntityEnvelope<PNChannelMetadata>> input) throws PubNubException {
        if (input.body() != null) {
            return new PNSetChannelMetadataResult((EntityEnvelope)input.body());
        }
        return new PNSetChannelMetadataResult();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNSetChannelMetadataOperation;
    }

    @Override
    public CompositeParameterEnricher getCompositeParameterEnricher() {
        return super.getCompositeParameterEnricher();
    }

    @Override
    public SetChannelMetadata description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public SetChannelMetadata name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public SetChannelMetadata custom(Map<String, Object> custom) {
        this.custom = new HashMap<String, Object>(custom);
        return this;
    }
}

